/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.repack.noobutil.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mysticmods.mysticalworld.repack.noobutil.NoobUtil;
import mysticmods.mysticalworld.repack.noobutil.type.LazySupplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.logging.log4j.Logger;

public class LazyStateSupplier
extends LazySupplier<BlockState>
implements INBTSerializable<CompoundNBT> {
    public static Codec<LazyStateSupplier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.field_240908_a_.fieldOf("location").forGetter(o -> o.location), (App)PropertyPair.CODEC.listOf().fieldOf("properties").forGetter(o -> o.properties), (App)BlockState.field_235877_b_.optionalFieldOf("state").forGetter(o -> o.state)).apply((Applicative)instance, (loc, props, state) -> state.map(o -> new LazyStateSupplier((BlockState)o, (List<PropertyPair>)props)).orElseGet(() -> new LazyStateSupplier((ResourceLocation)loc, (List<PropertyPair>)props))));
    private final ResourceLocation location;
    private final Optional<BlockState> state;
    private final List<PropertyPair> properties = new ArrayList<PropertyPair>();

    public LazyStateSupplier(String namespace, String name) {
        this(new ResourceLocation(namespace, name));
    }

    public LazyStateSupplier(ResourceLocation location) {
        this(location, null);
    }

    public LazyStateSupplier(ResourceLocation location, @Nullable List<PropertyPair> pairs) {
        if (pairs != null) {
            this.properties.addAll(pairs);
        }
        this.supplier = () -> {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
            if (block != null) {
                return this.apply(block.func_176223_P());
            }
            return Blocks.field_150350_a.func_176223_P();
        };
        this.location = location;
        this.state = Optional.empty();
    }

    public LazyStateSupplier(BlockState stateIn) {
        this(stateIn, null);
    }

    public LazyStateSupplier(BlockState stateIn, @Nullable List<PropertyPair> pairs) {
        this.state = Optional.of(stateIn);
        if (pairs != null) {
            this.properties.addAll(pairs);
        }
        this.supplier = () -> this.apply(this.state.orElse(Blocks.field_150350_a.func_176223_P()));
        this.location = stateIn.func_177230_c().getRegistryName();
    }

    public BlockState apply(BlockState state) {
        for (PropertyPair pair : this.properties) {
            state = pair.apply(state);
        }
        return state;
    }

    public LazyStateSupplier addPair(String name, boolean value) {
        this.properties.add(new PropertyPair(name, value ? "true" : "false", "boolean"));
        return this;
    }

    public LazyStateSupplier addPair(String name, int value) {
        this.properties.add(new PropertyPair(name, String.valueOf(value), "integer"));
        return this;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("lazy_state", (INBT)CODEC.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this).getOrThrow(false, arg_0 -> ((Logger)NoobUtil.logger).debug(arg_0)));
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        throw new NotImplementedException("deserializeNBT not implemented, use fromNBT static method");
    }

    public static LazyStateSupplier fromNBT(CompoundNBT nbt) {
        return (LazyStateSupplier)((Pair)CODEC.decode((DynamicOps)NBTDynamicOps.field_210820_a, (Object)nbt.func_74781_a("lazy_state")).getOrThrow(false, arg_0 -> ((Logger)NoobUtil.logger).debug(arg_0))).getFirst();
    }

    public static class PropertyPair {
        private final String propertyName;
        private final String value;
        private final String type;
        public static Codec<PropertyPair> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(o -> o.propertyName), (App)Codec.STRING.fieldOf("value").forGetter(o -> o.value), (App)Codec.STRING.fieldOf("type").forGetter(o -> o.type)).apply((Applicative)instance, PropertyPair::new));

        public PropertyPair(String propertyName, String value, String type) {
            this.propertyName = propertyName;
            this.value = value;
            this.type = type;
        }

        @Nullable
        protected Property<?> getProperty(Block block) {
            BlockState state = block.func_176223_P();
            Collection props = state.func_235904_r_();
            for (Property prop : props) {
                if (!prop.func_177701_a().equals(this.propertyName)) continue;
                return prop;
            }
            return null;
        }

        public BlockState apply(BlockState state) {
            Property<?> prop = this.getProperty(state.func_177230_c());
            if (prop == null) {
                return state;
            }
            switch (this.type) {
                case "boolean": {
                    return (BlockState)state.func_206870_a((Property)((BooleanProperty)prop), (Comparable)Boolean.valueOf(this.value));
                }
                case "int": {
                    return (BlockState)state.func_206870_a((Property)((IntegerProperty)prop), (Comparable)Integer.valueOf(this.value));
                }
            }
            throw new NotImplementedException("enum isn't serialized soz");
        }
    }
}

