/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.repack.noobutil.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mysticmods.mysticalworld.repack.noobutil.reference.ModData;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class ExcludingIngredient
extends Ingredient {
    private final ExcludingItemList excludingItemList;

    public static ExcludingIngredient create(ITag<Item> base, IItemProvider without) {
        return new ExcludingIngredient(Ingredient.func_199805_a(base), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{without}));
    }

    public static ExcludingIngredient create(ITag<Item> base, ITag<Item> without) {
        return new ExcludingIngredient(Ingredient.func_199805_a(base), Ingredient.func_199805_a(without));
    }

    private ExcludingIngredient(Ingredient base, Ingredient without) {
        this(new ExcludingItemList(base, without));
    }

    private ExcludingIngredient(ExcludingItemList excludingItemList) {
        super(Stream.of(excludingItemList));
        this.excludingItemList = excludingItemList;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        return this.excludingItemList.base.test(stack) && !this.excludingItemList.without.test(stack);
    }

    public boolean func_203189_d() {
        return this.func_193365_a().length == 0;
    }

    public boolean isSimple() {
        return this.excludingItemList.base.isSimple() && this.excludingItemList.without.isSimple();
    }

    public IIngredientSerializer<ExcludingIngredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<ExcludingIngredient> {
        public static final IIngredientSerializer<ExcludingIngredient> INSTANCE = new Serializer();

        private Serializer() {
        }

        public ExcludingIngredient parse(@Nonnull JsonObject json) {
            if (json.has("base") && json.has("without")) {
                return new ExcludingIngredient(Ingredient.func_199802_a((JsonElement)json.getAsJsonObject("base")), Ingredient.func_199802_a((JsonElement)json.getAsJsonObject("without")));
            }
            throw new JsonParseException("A without ingredient must have both a base ingredient and a negation ingredient.");
        }

        public ExcludingIngredient parse(@Nonnull PacketBuffer buffer) {
            Ingredient base = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient without = Ingredient.func_199566_b((PacketBuffer)buffer);
            return new ExcludingIngredient(base, without);
        }

        public void write(@Nonnull PacketBuffer buffer, ExcludingIngredient ingredient) {
            CraftingHelper.write((PacketBuffer)buffer, (Ingredient)ingredient.excludingItemList.base);
            CraftingHelper.write((PacketBuffer)buffer, (Ingredient)ingredient.excludingItemList.without);
        }
    }

    private static class ExcludingItemList
    implements Ingredient.IItemList {
        private final Ingredient base;
        private final Ingredient without;

        public ExcludingItemList(Ingredient base, Ingredient without) {
            this.base = base;
            this.without = without;
        }

        public Collection<ItemStack> func_199799_a() {
            return Arrays.stream(this.base.func_193365_a()).filter(stack -> !this.without.test(stack)).collect(Collectors.toList());
        }

        public JsonObject func_200303_b() {
            JsonObject json = new JsonObject();
            json.addProperty("type", ModData.getResourceLocation("excluding_ingredient").toString());
            json.add("base", this.base.func_200304_c());
            json.add("without", this.without.func_200304_c());
            return json;
        }
    }
}

