/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import mysticmods.mysticalworld.recipe.IDamageRecipe;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapedDamageRecipe
extends ShapedRecipe
implements IDamageRecipe {
    private final Ingredient damageItem;
    private final Ingredient damageIngredient;
    private final int damageAmount;

    private ShapedDamageRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn, Ingredient damageItem, int damageAmount) {
        super(idIn, groupIn, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn);
        this.damageItem = damageItem;
        this.damageAmount = damageAmount;
        this.damageIngredient = this.createDamageIngredient(damageItem);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        return this.getRemainingItems(inv, this.damageIngredient, this.damageAmount);
    }

    public static ShapedDamageRecipe create(ShapedRecipe recipe, Ingredient damageItem, int damageAmount) {
        return new ShapedDamageRecipe(recipe.func_199560_c(), recipe.func_193358_e(), recipe.getRecipeWidth(), recipe.getRecipeHeight(), (NonNullList<Ingredient>)recipe.func_192400_c(), recipe.func_77571_b(), damageItem, damageAmount);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShapedDamageRecipe> {
        public ShapedDamageRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ShapedRecipe result = (ShapedRecipe)IRecipeSerializer.field_222157_a.func_199425_a_(recipeId, json);
            Ingredient damageItem = Ingredient.func_199802_a((JsonElement)json.get("damage_item"));
            int damageAmount = JSONUtils.func_151208_a((JsonObject)json, (String)"damage_amount", (int)-1);
            if (damageAmount == -1) {
                throw new JsonSyntaxException("Invalid damage_amount for ShapedDamageRecipe.");
            }
            return ShapedDamageRecipe.create(result, damageItem, damageAmount);
        }

        public ShapedDamageRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            ShapedRecipe result = (ShapedRecipe)IRecipeSerializer.field_222157_a.func_199426_a_(recipeId, buffer);
            Ingredient damageItem = Ingredient.func_199566_b((PacketBuffer)buffer);
            int damageAmount = buffer.readInt();
            return ShapedDamageRecipe.create(result, damageItem, damageAmount);
        }

        public void toNetwork(PacketBuffer buffer, ShapedDamageRecipe recipe) {
            IRecipeSerializer.field_222157_a.func_199427_a_(buffer, (IRecipe)recipe);
            recipe.damageItem.func_199564_a(buffer);
            buffer.writeInt(recipe.damageAmount);
        }
    }
}

