/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.recipe;

import mysticmods.mysticalworld.init.ModRecipes;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class BlazeRocketRecipe
extends SpecialRecipe {
    private static final Ingredient INGREDIENT_PAPER = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151121_aF});
    private static final Ingredient INGREDIENT_BLAZE_POWDER = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151065_br});
    private static final Ingredient INGREDIENT_FIREWORK_STAR = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196153_dF});

    public BlazeRocketRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        boolean flag = false;
        int i = 0;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            if (INGREDIENT_PAPER.test(itemstack)) {
                if (flag) {
                    return false;
                }
                flag = true;
                continue;
            }
            if (!(INGREDIENT_BLAZE_POWDER.test(itemstack) ? ++i > 3 : !INGREDIENT_FIREWORK_STAR.test(itemstack))) continue;
            return false;
        }
        return flag && i >= 1;
    }

    public ItemStack assemble(CraftingInventory inv) {
        ItemStack itemstack = new ItemStack((IItemProvider)Items.field_196152_dE, 5);
        CompoundNBT compoundnbt = itemstack.func_190925_c("Fireworks");
        ListNBT listnbt = new ListNBT();
        int i = 0;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            CompoundNBT compoundnbt1;
            ItemStack itemstack1 = inv.func_70301_a(j);
            if (itemstack1.func_190926_b()) continue;
            if (INGREDIENT_BLAZE_POWDER.test(itemstack1)) {
                ++i;
                continue;
            }
            if (!INGREDIENT_FIREWORK_STAR.test(itemstack1) || (compoundnbt1 = itemstack1.func_179543_a("Explosion")) == null) continue;
            listnbt.add((Object)compoundnbt1);
        }
        compoundnbt.func_74774_a("Flight", (byte)(i * 2));
        if (!listnbt.isEmpty()) {
            compoundnbt.func_218657_a("Explosions", (INBT)listnbt);
        }
        return itemstack;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)Items.field_196152_dE);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.BLAZE_SERIALIZER.get();
    }
}

