/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.items;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mysticmods.mysticalworld.MWTags;
import mysticmods.mysticalworld.config.ConfigManager;
import mysticmods.mysticalworld.entity.ClamEntity;
import mysticmods.mysticalworld.init.ModEntities;
import mysticmods.mysticalworld.init.ModItems;
import mysticmods.mysticalworld.init.ModModifiers;
import mysticmods.mysticalworld.init.ModSounds;
import mysticmods.mysticalworld.loot.Serendipity;
import mysticmods.mysticalworld.repack.noobutil.type.LazySupplier;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PearleporterItem
extends Item {
    public static LazySupplier<Ingredient> PEARL_INGREDIENT = new LazySupplier<Ingredient>(() -> Ingredient.func_199805_a(MWTags.Items.PEARL_GEM));

    public PearleporterItem(Item.Properties properties) {
        super(properties);
    }

    public boolean func_82789_a(ItemStack pToRepair, ItemStack pRepair) {
        return pToRepair.func_77973_b() == this && PEARL_INGREDIENT.get().test(pRepair);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_151370_z || enchantment == Enchantments.field_185307_s;
    }

    public boolean func_77616_k(ItemStack pStack) {
        return true;
    }

    public int func_77619_b() {
        return 32;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        Map map = EnchantmentHelper.func_82781_a((ItemStack)book);
        for (Enchantment enchantment : map.keySet()) {
            if (enchantment == Enchantments.field_151370_z || enchantment == Enchantments.field_185307_s) continue;
            return false;
        }
        return super.isBookEnchantable(stack, book);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity entity, Hand hand) {
        if (entity.func_200600_R() != ModEntities.CLAM.get()) {
            return ActionResultType.FAIL;
        }
        if (entity.field_70170_p.field_72995_K) {
            return ActionResultType.PASS;
        }
        ClamEntity clam = (ClamEntity)entity;
        if ((Integer)clam.func_184212_Q().func_187225_a(ClamEntity.age) >= ConfigManager.CLAM_CONFIG.getMaxAge()) {
            int luck = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_151370_z, (LivingEntity)playerIn) + (int)playerIn.func_184817_da();
            int count = 1 + Serendipity.calculateAdditional(playerIn.func_233637_b_(ModModifiers.SERENDIPITY.get())) + luck / 2 + field_77697_d.nextInt(1 + luck);
            ItemStack result = (Boolean)clam.func_184212_Q().func_187225_a(ClamEntity.isEnder) != false ? new ItemStack((IItemProvider)Items.field_151079_bi, count) : new ItemStack((IItemProvider)ModItems.PEARL_GEM.get(), count);
            clam.func_184212_Q().func_187227_b(ClamEntity.age, (Object)field_77697_d.nextInt(ConfigManager.CLAM_CONFIG.getInitialAge()));
            ItemEntity ent = entity.func_70099_a(result, 1.0f);
            if (ent != null) {
                ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.1f), (double)(field_77697_d.nextFloat() * 0.05f), (double)((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.1f)));
                if (!playerIn.func_184812_l_()) {
                    stack.func_222118_a(1, (LivingEntity)playerIn, e -> e.func_213334_d(hand));
                }
                playerIn.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), ModSounds.PEARLEPORTER_USE.get(), SoundCategory.PLAYERS, 1.0f, 0.2f);
            }
        } else {
            int diff = ConfigManager.CLAM_CONFIG.getMaxAge() - (Integer)clam.func_184212_Q().func_187225_a(ClamEntity.age) / 20;
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("mysticalworld.item.pearleporter_immature", new Object[]{diff}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_PURPLE)), true);
        }
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack pStack, @Nullable World pLevel, List<ITextComponent> pTooltip, ITooltipFlag pFlag) {
        super.func_77624_a(pStack, pLevel, pTooltip, pFlag);
        pTooltip.add((ITextComponent)new StringTextComponent(""));
        pTooltip.add((ITextComponent)new TranslationTextComponent("mysticalworld.item.pearleporter").func_230530_a_(Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true))));
    }
}

