/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.items;

import com.google.common.collect.Multimap;
import java.util.Map;
import javax.annotation.Nullable;
import mysticmods.mysticalworld.client.model.ModelHolder;
import mysticmods.mysticalworld.config.ConfigManager;
import mysticmods.mysticalworld.init.ModMaterials;
import mysticmods.mysticalworld.items.ModifiedArmorItem;
import mysticmods.mysticalworld.repack.noobutil.material.MaterialType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AntlerHatItem
extends ModifiedArmorItem {
    public AntlerHatItem(Item.Properties builder) {
        super(ModMaterials.ANTLER.getArmorMaterial(), EquipmentSlotType.HEAD, builder);
    }

    @Override
    public Map<Attribute, AttributeModifier> getModifiers() {
        return super.getModifiers();
    }

    @Override
    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        Multimap<Attribute, AttributeModifier> map = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EquipmentSlotType.HEAD && ConfigManager.HAT_CONFIG.getAntlerHealthBonus() != -1.0f) {
            map.put((Object)Attributes.field_233818_a_, (Object)this.getOrCreateModifier(Attributes.field_233818_a_, () -> new AttributeModifier(MaterialType.ARMOR_MODIFIERS[this.field_77881_a.func_188454_b()], "Antler Health Boost", (double)ConfigManager.HAT_CONFIG.getAntlerHealthBonus(), AttributeModifier.Operation.ADDITION)));
        }
        return map;
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (ConfigManager.HAT_CONFIG.getAntlerFrequency() == -1) {
            return;
        }
        if (!world.field_72995_K) {
            float f = player.func_110143_aJ();
            float f2 = ConfigManager.HAT_CONFIG.getAntlerThreshold() == -1 ? player.func_110138_aP() : player.func_110138_aP() - (float)ConfigManager.HAT_CONFIG.getAntlerThreshold();
            if (f < f2 && world.field_73012_v.nextInt(ConfigManager.HAT_CONFIG.getAntlerFrequency()) == 0) {
                if (player.func_70660_b(Effects.field_76428_l) != null) {
                    return;
                }
                player.func_70691_i(ConfigManager.HAT_CONFIG.getAntlerHealing());
                player.func_195064_c(new EffectInstance(Effects.field_76428_l, ConfigManager.HAT_CONFIG.getAntlerRegenDuration(), ConfigManager.HAT_CONFIG.getAntlerRegenAmplifier()));
                ItemStack head = player.func_184582_a(EquipmentSlotType.HEAD);
                if (ConfigManager.HAT_CONFIG.getAntlerDamage() != -1) {
                    head.func_222118_a(ConfigManager.HAT_CONFIG.getAntlerDamage(), (LivingEntity)player, breaker -> breaker.func_213361_c(EquipmentSlotType.HEAD));
                }
            }
        }
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return "mysticalworld:textures/models/armor/antler_hat.png";
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        return (A)((Object)ModelHolder.antlerHatModel);
    }
}

