/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mysticmods.mysticalworld.world.structures.BarrowStructure;
import mysticmods.mysticalworld.world.structures.HutStructure;
import mysticmods.mysticalworld.world.structures.RuinedHutStructure;
import mysticmods.mysticalworld.world.structures.SandHouseStructure;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="mysticalworld", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModStructures {
    private static final Set<Structure<?>> STRUCTURES = new HashSet();
    public static final Structure<NoFeatureConfig> HUT_STRUCTURE = ModStructures.register("hut", new HutStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final Structure<NoFeatureConfig> BARROW_STRUCTURE = ModStructures.register("barrow", new BarrowStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final Structure<NoFeatureConfig> RUINED_HUT_STRUCTURE = ModStructures.register("ruined_hut", new RuinedHutStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final Structure<NoFeatureConfig> SAND_HOUSE_STRUCTURE = ModStructures.register("sand_house", new SandHouseStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    private static <T extends IFeatureConfig> Structure<T> register(String name, Structure<T> feature) {
        ResourceLocation rl = new ResourceLocation("mysticalworld", name);
        feature.setRegistryName(rl);
        STRUCTURES.add(feature);
        return feature;
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Structure<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])STRUCTURES.toArray(new Structure[0]));
    }

    public static void setupStructures() {
        ModStructures.setupStructure(HUT_STRUCTURE, new StructureSeparationSettings(45, 20, 12886419), true);
        ModStructures.setupStructure(BARROW_STRUCTURE, new StructureSeparationSettings(150, 65, 314159223), true);
        ModStructures.setupStructure(RUINED_HUT_STRUCTURE, new StructureSeparationSettings(70, 35, 8266497), true);
        ModStructures.setupStructure(SAND_HOUSE_STRUCTURE, new StructureSeparationSettings(90, 40, 11496812), true);
    }

    public static <F extends Structure<?>> void setupStructure(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> temp = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                temp.put(structure, structureSeparationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = temp;
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }
}

