/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.init;

import com.google.common.collect.Sets;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import mysticmods.mysticalworld.MysticalWorld;
import mysticmods.mysticalworld.blocks.PetrifiedFlowerBlock;
import mysticmods.mysticalworld.config.ConfigManager;
import mysticmods.mysticalworld.config.FeatureConfig;
import mysticmods.mysticalworld.config.OreConfig;
import mysticmods.mysticalworld.init.ConfiguredStructures;
import mysticmods.mysticalworld.init.ModBlocks;
import mysticmods.mysticalworld.init.ModEntities;
import mysticmods.mysticalworld.init.ModStructures;
import mysticmods.mysticalworld.repack.noobutil.registry.ConfiguredRegistry;
import mysticmods.mysticalworld.repack.noobutil.type.LazySupplier;
import mysticmods.mysticalworld.repack.registrate.util.entry.RegistryEntry;
import mysticmods.mysticalworld.world.SupplierBlockStateProvider;
import mysticmods.mysticalworld.world.feature.SupplierOreFeature;
import mysticmods.mysticalworld.world.feature.SupplierOreFeatureConfig;
import mysticmods.mysticalworld.world.placement.DimensionConfig;
import mysticmods.mysticalworld.world.placement.DimensionCountPlacement;
import mysticmods.mysticalworld.world.placement.DimensionCountRangeConfig;
import mysticmods.mysticalworld.world.placement.DimensionPlacement;
import mysticmods.mysticalworld.world.test.OreGenTest;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.IRuleTestType;
import net.minecraft.world.gen.foliageplacer.FancyFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.FancyTrunkPlacer;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ModFeatures {
    public static final ConfiguredRegistry<ConfiguredFeature<?, ?>> REGISTRY = new ConfiguredRegistry("mysticalworld", WorldGenRegistries.field_243653_e);
    public static final IRuleTestType<OreGenTest> ORE_GEN = IRuleTestType.func_237129_a_((String)"ore_gen", OreGenTest.CODEC);
    public static final RegistryEntry<SupplierOreFeature> SUPPLIER_ORE = MysticalWorld.REGISTRATE.simple("supplier_ore_feature", Feature.class, () -> new SupplierOreFeature(SupplierOreFeatureConfig.CODEC));
    private static final RegistryEntry<DimensionCountPlacement> DIMENSION_COUNT_PLACEMENT = MysticalWorld.REGISTRATE.simple("dimension_count_placement", Placement.class, () -> new DimensionCountPlacement(DimensionCountRangeConfig.CODEC));
    private static final RegistryEntry<DimensionPlacement> DIMENSION_PLACEMENT = MysticalWorld.REGISTRATE.simple("dimension_placement", Placement.class, () -> new DimensionPlacement(DimensionConfig.CODEC));
    public static final RegistryEntry<BlockStateProviderType<SupplierBlockStateProvider>> SUPPLIER_STATE_PROVIDER = MysticalWorld.REGISTRATE.simple("supplier_state_provider", BlockStateProviderType.class, () -> new BlockStateProviderType(SupplierBlockStateProvider.CODEC));
    public static ConfiguredFeature<?, ?> CHARRED_TREE = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SupplierBlockStateProvider("mysticalworld", "charred_log"), (BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_150350_a.func_176223_P()), (FoliagePlacer)new FancyFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)4), 4), (AbstractTrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0, OptionalInt.of(4))).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_()).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, (float)ConfigManager.DEAD_TREE_CONFIG.getChance(), 1)));
    public static Supplier<ConfiguredFeature<?, ?>> STONEPETAL_PATCH = new LazySupplier<ConfiguredFeature>(() -> (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((PetrifiedFlowerBlock)((Object)((Object)ModBlocks.STONEPETAL.get()))).func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(ConfigManager.STONEPETAL_CONFIG.getTries()).func_227316_a_((Set)Sets.newHashSet((Object[])new Block[]{Blocks.field_150348_b})).func_227322_d_()).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(ConfigManager.STONEPETAL_CONFIG.getRepeats()));
    private static final List<ConfiguredFeature<?, ?>> ORE_FEATURES = new ArrayList();
    private static MethodHandle GETCODEC_METHOD = null;

    public static void generateFeatures() {
        for (OreConfig config : ConfigManager.ORE_CONFIG) {
            if (config.getChance() <= 0) continue;
            ConfiguredFeature feat = SUPPLIER_ORE.get().func_225566_b_(new SupplierOreFeatureConfig(config.getRule(), config.getOreKey(), config.getSize())).func_227228_a_(DIMENSION_COUNT_PLACEMENT.get().func_227446_a_(new DimensionCountRangeConfig(config.getChance(), config.getMinY(), 0, config.getMaxY() - config.getMinY(), config.getDimensions())));
            ORE_FEATURES.add(feat);
            REGISTRY.register(config.getName().toLowerCase(), feat);
        }
        CHARRED_TREE = CHARRED_TREE.func_227228_a_(DIMENSION_PLACEMENT.get().func_227446_a_(new DimensionConfig(ConfigManager.DEAD_TREE_CONFIG.getDimensions())));
        REGISTRY.register("charred_tree", CHARRED_TREE);
        ConfigManager.DEAD_TREE_CONFIG.setSupplierFeature(() -> () -> CHARRED_TREE);
        ConfiguredFeature stonepetalPatch = STONEPETAL_PATCH.get().func_227228_a_(DIMENSION_PLACEMENT.get().func_227446_a_(new DimensionConfig(ConfigManager.STONEPETAL_CONFIG.getDimensions())));
        STONEPETAL_PATCH = () -> stonepetalPatch;
        REGISTRY.register("stonepetal_patch", stonepetalPatch);
        ConfigManager.STONEPETAL_CONFIG.setSupplierFeature(() -> STONEPETAL_PATCH);
    }

    public static void load() {
    }

    private static void tryPlaceFeature(BiomeLoadingEvent event, Set<BiomeDictionary.Type> types, FeatureConfig<?> config) {
        Supplier<ConfiguredFeature<?, ?>> sup;
        for (BiomeDictionary.Type rest : config.getBiomeRestrictions()) {
            if (!types.contains(rest)) continue;
            return;
        }
        boolean place = false;
        if (config.getBiomes().isEmpty()) {
            place = true;
        } else {
            Set<BiomeDictionary.Type> biomeTypes = config.getBiomes();
            for (BiomeDictionary.Type poss : biomeTypes) {
                if (!types.contains(poss)) continue;
                place = true;
                break;
            }
        }
        if (!place) {
            return;
        }
        if (config.isFeature()) {
            sup = config.getFeature();
            if (sup == null) {
                return;
            }
            event.getGeneration().getFeatures(config.getStage()).add(sup);
        } else {
            sup = config.getStructure();
            if (sup == null) {
                return;
            }
            event.getGeneration().getStructures().add(sup);
            if (config == ConfigManager.HUT_CONFIG) {
                event.getGeneration().getStructures().add(() -> ConfiguredStructures.CONFIGURED_RUINED_HUT);
            }
        }
    }

    public static void onBiomeLoad(BiomeLoadingEvent event) {
        for (ConfiguredFeature<?, ?> ore : ORE_FEATURES) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_ORES).add(() -> ore);
        }
        if (event.getName() != null) {
            RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
            Set types = BiomeDictionary.getTypes((RegistryKey)key);
            ModEntities.registerEntity(event, types);
            if (!ModList.get().isLoaded("dynamictrees")) {
                ModFeatures.tryPlaceFeature(event, types, ConfigManager.DEAD_TREE_CONFIG);
            }
            ModFeatures.tryPlaceFeature(event, types, ConfigManager.STONEPETAL_CONFIG);
            ModFeatures.tryPlaceFeature(event, types, ConfigManager.HUT_CONFIG);
            ModFeatures.tryPlaceFeature(event, types, ConfigManager.BARROW_CONFIG);
            ModFeatures.tryPlaceFeature(event, types, ConfigManager.SAND_HOUSE_CONFIG);
        }
    }

    public static void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ResourceLocation chunkGen;
            ServerWorld world = (ServerWorld)event.getWorld();
            if (world.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && world.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            if (GETCODEC_METHOD == null) {
                Method codec = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
                MethodHandles.Lookup l = MethodHandles.lookup();
                try {
                    GETCODEC_METHOD = l.unreflect(codec);
                }
                catch (IllegalAccessException e) {
                    MysticalWorld.LOG.error("Unable to unreflect codec getter.", (Throwable)e);
                    return;
                }
            }
            try {
                chunkGen = Registry.field_239690_aB_.func_177774_c((Object)GETCODEC_METHOD.invokeExact(world.func_72863_F().field_186029_c));
            }
            catch (Throwable throwable) {
                MysticalWorld.LOG.error("Unable to look up chunk provider's generator", throwable);
                return;
            }
            if (chunkGen != null && chunkGen.func_110624_b().equals("terraforrged")) {
                return;
            }
            if (world.func_234923_W_().equals(World.field_234918_g_)) {
                HashMap<Structure<NoFeatureConfig>, Object> temp = new HashMap<Structure<NoFeatureConfig>, Object>(world.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
                temp.put(ModStructures.BARROW_STRUCTURE, DimensionStructuresSettings.field_236191_b_.get(ModStructures.BARROW_STRUCTURE));
                temp.put(ModStructures.HUT_STRUCTURE, DimensionStructuresSettings.field_236191_b_.get(ModStructures.HUT_STRUCTURE));
                temp.put(ModStructures.RUINED_HUT_STRUCTURE, DimensionStructuresSettings.field_236191_b_.get(ModStructures.RUINED_HUT_STRUCTURE));
                temp.put(ModStructures.SAND_HOUSE_STRUCTURE, DimensionStructuresSettings.field_236191_b_.get(ModStructures.SAND_HOUSE_STRUCTURE));
                world.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = temp;
            }
        }
    }
}

