/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.init;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mysticmods.mysticalworld.MysticalWorld;
import mysticmods.mysticalworld.config.ConfigManager;
import mysticmods.mysticalworld.config.MobConfig;
import mysticmods.mysticalworld.entity.BeetleEntity;
import mysticmods.mysticalworld.entity.ClamEntity;
import mysticmods.mysticalworld.entity.DeerEntity;
import mysticmods.mysticalworld.entity.DuckEntity;
import mysticmods.mysticalworld.entity.EnderminiEntity;
import mysticmods.mysticalworld.entity.FrogEntity;
import mysticmods.mysticalworld.entity.HellSproutEntity;
import mysticmods.mysticalworld.entity.LavaCatEntity;
import mysticmods.mysticalworld.entity.OwlEntity;
import mysticmods.mysticalworld.entity.SilkwormEntity;
import mysticmods.mysticalworld.entity.SilverFoxEntity;
import mysticmods.mysticalworld.entity.SproutEntity;
import mysticmods.mysticalworld.init.ModItems;
import mysticmods.mysticalworld.loot.conditions.HasHorns;
import mysticmods.mysticalworld.loot.conditions.IsColor;
import mysticmods.mysticalworld.loot.conditions.IsEnder;
import mysticmods.mysticalworld.loot.conditions.IsLava;
import mysticmods.mysticalworld.loot.conditions.IsMature;
import mysticmods.mysticalworld.loot.conditions.IsObsidian;
import mysticmods.mysticalworld.repack.registrate.util.LazySpawnEggItem;
import mysticmods.mysticalworld.repack.registrate.util.entry.RegistryEntry;
import mysticmods.mysticalworld.repack.registrate.util.nullness.NonNullFunction;
import net.minecraft.advancements.criterion.EntityFlagsPredicate;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.EntityHasProperty;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootingEnchantBonus;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.loot.functions.Smelt;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class ModEntities {
    public static List<RegistryEntry<? extends LazySpawnEggItem<?>>> SPAWN_EGGS = new ArrayList();
    public static RegistryEntry<EntityType<BeetleEntity>> BEETLE = MysticalWorld.REGISTRATE.entity("beetle", BeetleEntity::new, EntityClassification.CREATURE).properties(o -> o.func_220321_a(0.75f, 0.75f).setTrackingRange(16).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).loot((p, e) -> p.func_218582_a((EntityType<?>)e, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.CARAPACE.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)2.0f, (float)4.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151123_aH).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)))).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1))))).register();
    public static RegistryEntry<EntityType<DeerEntity>> DEER = MysticalWorld.REGISTRATE.entity("deer", DeerEntity::new, EntityClassification.CREATURE).loot((p, e) -> p.func_218582_a((EntityType<?>)e, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151116_aA).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)3.0f)))).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1))).func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.VENISON.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)Smelt.func_215953_b().func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_217987_a(EntityFlagsPredicate.Builder.func_217967_a().func_217968_a(Boolean.valueOf(true)).func_217966_b()))))).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1))).func_216040_a(LootPool.func_216096_a().func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ANTLERS.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)1))).func_212840_b_(HasHorns.builder())).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1))))).properties(o -> o.func_220321_a(1.0f, 1.0f).setTrackingRange(16).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).register();
    public static RegistryEntry<EntityType<FrogEntity>> FROG = MysticalWorld.REGISTRATE.entity("frog", FrogEntity::new, EntityClassification.AMBIENT).loot((p, e) -> p.func_218582_a((EntityType<?>)e, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151123_aH).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)))).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1))))).properties(o -> o.func_220321_a(0.5f, 0.5f).setTrackingRange(16).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).register();
    public static RegistryEntry<EntityType<SilverFoxEntity>> SILVER_FOX = MysticalWorld.REGISTRATE.entity("silver_fox", SilverFoxEntity::new, EntityClassification.CREATURE).loot((p, e) -> p.func_218582_a((EntityType<?>)e, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.PELT.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)))).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1))))).properties(o -> o.func_220321_a(0.75f, 0.75f).setTrackingRange(16).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).register();
    public static RegistryEntry<EntityType<HellSproutEntity>> HELL_SPROUT = MysticalWorld.REGISTRATE.entity("hell_sprout", HellSproutEntity::new, EntityClassification.CREATURE).loot((p, e) -> p.func_218582_a((EntityType<?>)e, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151075_bm).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1))))).properties(o -> o.func_220321_a(0.5f, 1.0f).setTrackingRange(16).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3).func_220320_c()).register();
    public static RegistryEntry<EntityType<SproutEntity>> SPROUT = MysticalWorld.REGISTRATE.entity("sprout", SproutEntity::new, EntityClassification.CREATURE).loot((p, e) -> p.func_218582_a((EntityType<?>)e, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151127_ba).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_212840_b_(IsColor.builder("green")).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1))).func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.AUBERGINE.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_212841_b_((ILootFunction.IBuilder)Smelt.func_215953_b().func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_217987_a(EntityFlagsPredicate.Builder.func_217967_a().func_217968_a(Boolean.valueOf(true)).func_217966_b()))))).func_212840_b_(IsColor.builder("purple")).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1))).func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_185164_cV).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_212841_b_((ILootFunction.IBuilder)Smelt.func_215953_b().func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_217987_a(EntityFlagsPredicate.Builder.func_217967_a().func_217968_a(Boolean.valueOf(true)).func_217966_b()))))).func_212840_b_(IsColor.builder("red")).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1))).func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151174_bG).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_212841_b_((ILootFunction.IBuilder)Smelt.func_215953_b().func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_217987_a(EntityFlagsPredicate.Builder.func_217967_a().func_217968_a(Boolean.valueOf(true)).func_217966_b()))))).func_212840_b_(IsColor.builder("tan")).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1))))).properties(o -> o.func_220321_a(0.5f, 1.0f).setTrackingRange(16).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).register();
    public static RegistryEntry<EntityType<EnderminiEntity>> ENDERMINI = MysticalWorld.REGISTRATE.entity("endermini", EnderminiEntity::new, EntityClassification.MONSTER).loot((p, e) -> p.func_218582_a((EntityType<?>)e, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.YOUNG_PEARL.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)3.0f)))).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1))))).properties(o -> o.func_220321_a(0.3f, 1.45f).setTrackingRange(32).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).register();
    public static RegistryEntry<EntityType<LavaCatEntity>> LAVA_CAT = MysticalWorld.REGISTRATE.entity("lava_cat", LavaCatEntity::new, EntityClassification.CREATURE).loot((p, e) -> p.func_218582_a((EntityType<?>)e, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a(((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221655_bP).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)1))).func_212840_b_(IsObsidian.builder())).func_212840_b_(RandomChance.func_216004_a((float)0.7f))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221585_m).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)1))).func_212840_b_(IsObsidian.builder())).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221585_m).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)1))).func_212840_b_(IsLava.builder())).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1))))).properties(o -> o.func_220321_a(0.75f, 0.875f).setTrackingRange(34).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).register();
    public static RegistryEntry<EntityType<OwlEntity>> OWL = MysticalWorld.REGISTRATE.entity("owl", OwlEntity::new, EntityClassification.CREATURE).loot((p, e) -> p.func_218582_a((EntityType<?>)e, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151008_G).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)3.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1))))).properties(o -> o.func_220321_a(0.5f, 0.9f).setTrackingRange(16).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).register();
    public static RegistryEntry<EntityType<SilkwormEntity>> SILKWORM = MysticalWorld.REGISTRATE.entity("silkworm", SilkwormEntity::new, EntityClassification.CREATURE).loot((p, e) -> p.func_218582_a((EntityType<?>)e, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.SILKWORM_EGG.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f)))).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1))))).properties(o -> o.func_220321_a(0.8f, 0.6f).setTrackingRange(5).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).register();
    public static RegistryEntry<EntityType<DuckEntity>> DUCK = MysticalWorld.REGISTRATE.entity("duck", DuckEntity::new, EntityClassification.CREATURE).loot((p, e) -> p.func_218582_a((EntityType<?>)e, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151008_G).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)3.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1))))).properties(o -> o.func_220321_a(0.5f, 0.9f).setTrackingRange(16).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).register();
    public static RegistryEntry<EntityType<ClamEntity>> CLAM = MysticalWorld.REGISTRATE.entity("clam", ClamEntity::new, EntityClassification.WATER_CREATURE).loot((p, e) -> p.func_218582_a((EntityType<?>)e, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a(((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151079_bi).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)1))).func_212840_b_(IsMature.builder())).func_212840_b_(IsEnder.builder())).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1))).func_216040_a(LootPool.func_216096_a().func_216045_a(((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.PEARL_GEM.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)1))).func_212840_b_(IsMature.builder())).func_212840_b_(IsEnder.builder().func_216298_a())).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1))))).properties(o -> o.func_220321_a(0.75f, 0.75f).setTrackingRange(16).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3)).register();
    public static BiMap<RegistryEntry<? extends EntityType<?>>, MobConfig> configMap;

    private static <E extends Entity> NonNullFunction<Item.Properties, LazySpawnEggItem<E>> spawnEgg(RegistryEntry<EntityType<E>> entity, int color1, int color2) {
        return properties -> new LazySpawnEggItem(entity, color1, color2, (Item.Properties)properties);
    }

    public static void registerEntity(BiomeLoadingEvent event, Set<BiomeDictionary.Type> types) {
        for (Map.Entry entry : configMap.entrySet()) {
            MobConfig conf = (MobConfig)entry.getValue();
            if (!conf.shouldRegister()) continue;
            HashSet<BiomeDictionary.Type> types2 = new HashSet<BiomeDictionary.Type>(types);
            types2.retainAll(conf.getBiomes());
            if (types2.isEmpty()) continue;
            if (conf.getRestriction() == BiomeDictionary.Type.NETHER && event.getCategory() == Biome.Category.NETHER) {
                event.getSpawns().getSpawner(conf.getClassification()).add(new MobSpawnInfo.Spawners((EntityType)((RegistryEntry)entry.getKey()).get(), conf.getChance(), conf.getMin(), conf.getMax()));
                continue;
            }
            if (conf.getRestriction() == BiomeDictionary.Type.OVERWORLD && event.getCategory() != Biome.Category.NETHER && event.getCategory() != Biome.Category.THEEND) {
                event.getSpawns().getSpawner(conf.getClassification()).add(new MobSpawnInfo.Spawners((EntityType)((RegistryEntry)entry.getKey()).get(), conf.getChance(), conf.getMin(), conf.getMax()));
                continue;
            }
            if (conf.getRestriction() != BiomeDictionary.Type.END || event.getCategory() != Biome.Category.THEEND) continue;
            event.getSpawns().getSpawner(conf.getClassification()).add(new MobSpawnInfo.Spawners((EntityType)((RegistryEntry)entry.getKey()).get(), conf.getChance(), conf.getMin(), conf.getMax()));
        }
        if (event.getName() != null && event.getName().func_110624_b().equals("mysticalbiomes") && event.getName().func_110623_a().contains("sprout")) {
            event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners(SPROUT.get(), 18, 2, 8));
        }
    }

    public static void load() {
    }

    public static void registerEntities() {
        EntitySpawnPlacementRegistry.func_209343_a(DEER.get(), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(FROG.get(), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(SPROUT.get(), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(SILVER_FOX.get(), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(BEETLE.get(), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(OWL.get(), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, OwlEntity::placement);
        EntitySpawnPlacementRegistry.func_209343_a(LAVA_CAT.get(), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, LavaCatEntity::placement);
        EntitySpawnPlacementRegistry.func_209343_a(HELL_SPROUT.get(), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, LavaCatEntity::placement);
        EntitySpawnPlacementRegistry.func_209343_a(ENDERMINI.get(), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EnderminiEntity::checkMonsterSpawnRules);
        EntitySpawnPlacementRegistry.func_209343_a(DUCK.get(), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(CLAM.get(), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ClamEntity::checkClamSpawnRules);
    }

    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put(BEETLE.get(), BeetleEntity.attributes().func_233813_a_());
        event.put(DEER.get(), DeerEntity.attributes().func_233813_a_());
        event.put(FROG.get(), FrogEntity.attributes().func_233813_a_());
        event.put(SILVER_FOX.get(), SilverFoxEntity.attributes().func_233813_a_());
        event.put(SPROUT.get(), SproutEntity.attributes().func_233813_a_());
        event.put(ENDERMINI.get(), EnderminiEntity.attributes().func_233813_a_());
        event.put(LAVA_CAT.get(), LavaCatEntity.attributes().func_233813_a_());
        event.put(OWL.get(), OwlEntity.attributes().func_233813_a_());
        event.put(SILKWORM.get(), SilkwormEntity.attributes().func_233813_a_());
        event.put(HELL_SPROUT.get(), HellSproutEntity.attributes().func_233813_a_());
        event.put(DUCK.get(), DuckEntity.attributes().func_233813_a_());
        event.put(CLAM.get(), ClamEntity.attributes().func_233813_a_());
    }

    static {
        SPAWN_EGGS.add(MysticalWorld.REGISTRATE.item("beetle_spawn_egg", ModEntities.spawnEgg(BEETLE, 4294036, 2170133)).properties(p -> p.func_200916_a(ItemGroup.field_78026_f)).model((ctx, prov) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)prov.withExistingParent(ctx.getName(), new ResourceLocation("item/template_spawn_egg"));
        }).register());
        SPAWN_EGGS.add(MysticalWorld.REGISTRATE.item("deer_spawn_egg", ModEntities.spawnEgg(DEER, 10585176, 6180147)).properties(p -> p.func_200916_a(ItemGroup.field_78026_f)).model((ctx, prov) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)prov.withExistingParent(ctx.getName(), new ResourceLocation("item/template_spawn_egg"));
        }).register());
        SPAWN_EGGS.add(MysticalWorld.REGISTRATE.item("frog_spawn_egg", ModEntities.spawnEgg(FROG, 2642484, 14411415)).properties(p -> p.func_200916_a(ItemGroup.field_78026_f)).model((ctx, prov) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)prov.withExistingParent(ctx.getName(), new ResourceLocation("item/template_spawn_egg"));
        }).register());
        SPAWN_EGGS.add(MysticalWorld.REGISTRATE.item("silver_fox_spawn_egg", ModEntities.spawnEgg(SILVER_FOX, 10391688, 16113875)).properties(p -> p.func_200916_a(ItemGroup.field_78026_f)).model((ctx, prov) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)prov.withExistingParent(ctx.getName(), new ResourceLocation("item/template_spawn_egg"));
        }).register());
        SPAWN_EGGS.add(MysticalWorld.REGISTRATE.item("sprout_spawn_egg", ModEntities.spawnEgg(SPROUT, 15266882, 13705050)).properties(p -> p.func_200916_a(ItemGroup.field_78026_f)).model((ctx, prov) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)prov.withExistingParent(ctx.getName(), new ResourceLocation("item/template_spawn_egg"));
        }).register());
        SPAWN_EGGS.add(MysticalWorld.REGISTRATE.item("endermini_spawn_egg", ModEntities.spawnEgg(ENDERMINI, 10559096, 6622398)).properties(p -> p.func_200916_a(ItemGroup.field_78026_f)).model((ctx, prov) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)prov.withExistingParent(ctx.getName(), new ResourceLocation("item/template_spawn_egg"));
        }).register());
        SPAWN_EGGS.add(MysticalWorld.REGISTRATE.item("lava_cat_spawn_egg", ModEntities.spawnEgg(LAVA_CAT, 14562613, 15242771)).properties(p -> p.func_200916_a(ItemGroup.field_78026_f)).model((ctx, prov) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)prov.withExistingParent(ctx.getName(), new ResourceLocation("item/template_spawn_egg"));
        }).register());
        SPAWN_EGGS.add(MysticalWorld.REGISTRATE.item("owl_spawn_egg", ModEntities.spawnEgg(OWL, 9200970, 14600634)).properties(p -> p.func_200916_a(ItemGroup.field_78026_f)).model((ctx, prov) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)prov.withExistingParent(ctx.getName(), new ResourceLocation("item/template_spawn_egg"));
        }).register());
        SPAWN_EGGS.add(MysticalWorld.REGISTRATE.item("silkworm_spawn_egg", ModEntities.spawnEgg(SILKWORM, 13749965, 6512219)).properties(p -> p.func_200916_a(ItemGroup.field_78026_f)).model((ctx, prov) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)prov.withExistingParent(ctx.getName(), new ResourceLocation("item/template_spawn_egg"));
        }).register());
        SPAWN_EGGS.add(MysticalWorld.REGISTRATE.item("hell_sprout_spawn_egg", ModEntities.spawnEgg(HELL_SPROUT, 9044739, 15266882)).properties(p -> p.func_200916_a(ItemGroup.field_78026_f)).model((ctx, prov) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)prov.withExistingParent(ctx.getName(), new ResourceLocation("item/template_spawn_egg"));
        }).register());
        SPAWN_EGGS.add(MysticalWorld.REGISTRATE.item("duck_spawn_egg", ModEntities.spawnEgg(DUCK, 14997157, 15314230)).properties(p -> p.func_200916_a(ItemGroup.field_78026_f)).model((ctx, prov) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)prov.withExistingParent(ctx.getName(), new ResourceLocation("item/template_spawn_egg"));
        }).register());
        SPAWN_EGGS.add(MysticalWorld.REGISTRATE.item("clam_spawn_egg", ModEntities.spawnEgg(CLAM, 0xFFFDD0, 0xFADADD)).properties(p -> p.func_200916_a(ItemGroup.field_78026_f)).model((ctx, prov) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)prov.withExistingParent(ctx.getName(), new ResourceLocation("item/template_spawn_egg"));
        }).register());
        configMap = HashBiMap.create();
        configMap.put(BEETLE, (Object)ConfigManager.BEETLE_CONFIG);
        configMap.put(DEER, (Object)ConfigManager.DEER_CONFIG);
        configMap.put(FROG, (Object)ConfigManager.FROG_CONFIG);
        configMap.put(SILVER_FOX, (Object)ConfigManager.SILVER_FOX_CONFIG);
        configMap.put(SPROUT, (Object)ConfigManager.SPROUT_CONFIG);
        configMap.put(ENDERMINI, (Object)ConfigManager.ENDERMINI_CONFIG);
        configMap.put(LAVA_CAT, (Object)ConfigManager.LAVA_CAT_CONFIG);
        configMap.put(OWL, (Object)ConfigManager.OWL_CONFIG);
        configMap.put(HELL_SPROUT, (Object)ConfigManager.HELL_SPROUT_CONFIG);
        configMap.put(DUCK, (Object)ConfigManager.DUCK_CONFIG);
        configMap.put(CLAM, (Object)ConfigManager.CLAM_CONFIG);
    }
}

