/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.events.mappings;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mysticmods.mysticalworld.MysticalWorld;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="mysticalworld")
public class Remaps {
    public static ResourceLocation IGNORE = new ResourceLocation("mysticalworld", "ignore_remap");
    public static Map<ResourceLocation, ResourceLocation> remappedItems = new HashMap<ResourceLocation, ResourceLocation>();
    public static Map<ResourceLocation, ResourceLocation> remappedBlocks = new HashMap<ResourceLocation, ResourceLocation>();
    public static Map<ResourceLocation, ResourceLocation> remappedEntities = new HashMap<ResourceLocation, ResourceLocation>();

    private static void ignore(String oldName, RemapType type) {
        Remaps.remap(oldName, "ignore_remap", type);
    }

    private static void remap(String oldName, String newName, RemapType type) {
        Map<ResourceLocation, ResourceLocation> remapper = type.getMap().get();
        String mapType = type.getName();
        ResourceLocation oldRL = new ResourceLocation("mysticalworld", oldName);
        ResourceLocation newRL = new ResourceLocation("mysticalworld", newName);
        if (remapper.containsKey(oldRL)) {
            MysticalWorld.LOG.error("Invalid " + mapType + " remap: " + oldRL.toString() + " already exists and remaps to " + remapper.get(oldRL).toString() + ", cannot also remap to " + newRL.toString(), (Throwable)new IllegalStateException("Duplicate " + mapType + " remap"));
        }
        remapper.put(oldRL, newRL);
    }

    public static void remapItem(String o, String n) {
        Remaps.remap(o, n, RemapType.ITEM);
    }

    public static void remapBlock(String o, String n) {
        Remaps.remap(o, n, RemapType.BLOCK);
    }

    public static void remapEntity(String o, String n) {
        Remaps.remap(o, n, RemapType.ENTITY);
    }

    @SubscribeEvent
    public static void remapItemEvent(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            ResourceLocation remap = remappedItems.get(mapping.key);
            if (remap != null && remap.equals((Object)IGNORE)) {
                mapping.ignore();
                continue;
            }
            if (remap == null) continue;
            Item remapped = (Item)ForgeRegistries.ITEMS.getValue(remap);
            if (remapped == null || remapped == Items.field_190931_a) {
                MysticalWorld.LOG.error("Attempted remapping is invalid: " + mapping.key + " is remapped to " + remap + " but that item doesn't exist!");
                continue;
            }
            mapping.remap((IForgeRegistryEntry)remapped);
            MysticalWorld.LOG.info("Remapped item: " + mapping.key + " to " + remap);
        }
    }

    @SubscribeEvent
    public static void remapBlockEvent(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            ResourceLocation remap = remappedBlocks.get(mapping.key);
            if (remap != null && remap.equals((Object)IGNORE)) {
                mapping.ignore();
                continue;
            }
            if (remap == null) continue;
            Block remapped = (Block)ForgeRegistries.BLOCKS.getValue(remap);
            if (remapped == null || remapped == Blocks.field_150350_a) {
                MysticalWorld.LOG.error("Attempted remapping is invalid: " + mapping.key + " is remapped to " + remap + " but that block doesn't exist!");
                continue;
            }
            mapping.remap((IForgeRegistryEntry)remapped);
            MysticalWorld.LOG.info("Remapped block: " + mapping.key + " to " + remap);
        }
    }

    @SubscribeEvent
    public static void remapEntityEvent(RegistryEvent.MissingMappings<EntityType<?>> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            ResourceLocation remap = remappedEntities.get(mapping.key);
            if (remap != null && remap.equals((Object)IGNORE)) {
                mapping.ignore();
                continue;
            }
            if (remap == null) continue;
            EntityType remapped = (EntityType)ForgeRegistries.ENTITIES.getValue(remap);
            if (remapped == null) {
                MysticalWorld.LOG.error("Attempted remapping is invalid: " + mapping.key + " is remapped to " + remap + " but that entity doesn't exist!");
                continue;
            }
            mapping.remap((IForgeRegistryEntry)remapped);
            MysticalWorld.LOG.info("Remapped entity: " + mapping.key + " to " + remap);
        }
    }

    static {
        Remaps.ignore("drowned_head", RemapType.ITEM);
        Remaps.ignore("stray_head", RemapType.ITEM);
        Remaps.ignore("husk_head", RemapType.ITEM);
        Remaps.ignore("villager_head", RemapType.ITEM);
        Remaps.ignore("pillager_head", RemapType.ITEM);
        Remaps.ignore("zombie_pigman_head", RemapType.ITEM);
        Remaps.ignore("zombie_villager_head", RemapType.ITEM);
        Remaps.ignore("drowned_head", RemapType.BLOCK);
        Remaps.ignore("stray_head", RemapType.BLOCK);
        Remaps.ignore("husk_head", RemapType.BLOCK);
        Remaps.ignore("villager_head", RemapType.BLOCK);
        Remaps.ignore("pillager_head", RemapType.BLOCK);
        Remaps.ignore("zombie_pigman_head", RemapType.BLOCK);
        Remaps.ignore("zombie_villager_head", RemapType.BLOCK);
        Remaps.ignore("drowned_wall_head", RemapType.BLOCK);
        Remaps.ignore("stray_wall_head", RemapType.BLOCK);
        Remaps.ignore("husk_wall_head", RemapType.BLOCK);
        Remaps.ignore("villager_wall_head", RemapType.BLOCK);
        Remaps.ignore("pillager_wall_head", RemapType.BLOCK);
        Remaps.ignore("zombie_pigman_wall_head", RemapType.BLOCK);
        Remaps.ignore("zombie_villager_wall_head", RemapType.BLOCK);
        Remaps.ignore("rotten_apple", RemapType.ITEM);
        Remaps.remapBlock("wild_aubergine_crop", "wild_aubergine");
        Remaps.remapBlock("cracked_stone", "soft_stone");
        Remaps.remapBlock("cracked_stone_stairs", "soft_stone_stairs");
        Remaps.remapBlock("cracked_stone_slab", "soft_stone_slab");
        Remaps.remapBlock("cracked_stone_wall", "soft_stone_wall");
        Remaps.remapBlock("cracked_stone_wide_post", "soft_stone_wide_post");
        Remaps.remapBlock("cracked_stone_small_post", "soft_stone_small_post");
        Remaps.remapItem("cracked_stone", "soft_stone");
        Remaps.remapItem("cracked_stone_stairs", "soft_stone_stairs");
        Remaps.remapItem("cracked_stone_slab", "soft_stone_slab");
        Remaps.remapItem("cracked_stone_wall", "soft_stone_wall");
        Remaps.remapItem("cracked_stone_wide_post", "soft_stone_wide_post");
        Remaps.remapItem("cracked_stone_small_post", "soft_stone_small_post");
        Remaps.remapBlock("simple_thatch", "thatch");
        Remaps.remapItem("simple_thatch", "thatch");
        Remaps.remapBlock("amethyst_block", "sapphire_block");
        Remaps.remapBlock("amethyst_ore", "sapphire_ore");
        Remaps.remapBlock("amethyst_stairs", "sapphire_stairs");
        Remaps.remapBlock("amethyst_slab", "sapphire_slab");
        Remaps.remapBlock("amethyst_wall", "sapphire_wall");
        Remaps.remapBlock("amethyst_wide_post", "sapphire_wide_post");
        Remaps.remapBlock("amethyst_small_post", "sapphire_small_post");
        Remaps.remapItem("amethyst_block", "sapphire_block");
        Remaps.remapItem("amethyst_ore", "sapphire_ore");
        Remaps.remapItem("amethyst_stairs", "sapphire_stairs");
        Remaps.remapItem("amethyst_slab", "sapphire_slab");
        Remaps.remapItem("amethyst_wall", "sapphire_wall");
        Remaps.remapItem("amethyst_wide_post", "sapphire_wide_post");
        Remaps.remapItem("amethyst_small_post", "sapphire_small_post");
        Remaps.remapItem("amethyst", "sapphire");
        Remaps.remapItem("amethyst_axe", "sapphire_axe");
        Remaps.remapItem("amethyst_boots", "sapphire_boots");
        Remaps.remapItem("amethyst_chestplate", "sapphire_chestplate");
        Remaps.remapItem("amethyst_helmet", "sapphire_helmet");
        Remaps.remapItem("amethyst_hoe", "sapphire_hoe");
        Remaps.remapItem("amethyst_knife", "sapphire_knife");
        Remaps.remapItem("amethyst_leggings", "sapphire_leggings");
        Remaps.remapItem("amethyst_pickaxe", "sapphire_pickaxe");
        Remaps.remapItem("amethyst_shovel", "sapphire_shovel");
        Remaps.remapItem("amethyst_spear", "sapphire_spear");
        Remaps.remapItem("amethyst_sword", "sapphire_sword");
        Remaps.remapItem("beetle_mask", "beetle_helmet");
    }

    public static enum RemapType {
        ITEM("item", () -> remappedItems),
        BLOCK("block", () -> remappedBlocks),
        ENTITY("entity", () -> remappedEntities);

        private final String name;
        private final Supplier<Map<ResourceLocation, ResourceLocation>> map;

        public String getName() {
            return this.name;
        }

        public Supplier<Map<ResourceLocation, ResourceLocation>> getMap() {
            return this.map;
        }

        private RemapType(String name, Supplier<Map<ResourceLocation, ResourceLocation>> map) {
            this.name = name;
            this.map = map;
        }
    }
}

