/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.entity;

import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import mysticmods.mysticalworld.init.ModEntities;
import mysticmods.mysticalworld.init.ModSounds;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class LavaCatEntity
extends TameableEntity {
    private static final ResourceLocation LOOT_TABLE = new ResourceLocation("mysticalworld", "entity/lava_cat");
    private static final DataParameter<Boolean> IS_LAVA = EntityDataManager.func_187226_a(LavaCatEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final UUID OBSIDIAN_SPEED_MODIFIER = UUID.fromString("f58f95e9-fb51-4604-a66d-89433c9dd8a5");
    private static final AttributeModifier OBSIDIAN_SPEED = new AttributeModifier(OBSIDIAN_SPEED_MODIFIER, "Speed debuff for being obsidian", -0.05, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public LavaCatEntity(EntityType<? extends TameableEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 0.6, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151072_bj}), false));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 5.0f, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.3f));
        this.field_70714_bg.func_75776_a(8, (Goal)new OcelotAttackGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(9, (Goal)new BreedGoal((AnimalEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(10, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.8, 1));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public static boolean placement(EntityType<? extends AnimalEntity> pAnimal, IWorld worldIn, SpawnReason reason, BlockPos blockpos, Random pRandom) {
        Block block = worldIn.func_180495_p(blockpos.func_177977_b()).func_177230_c();
        return block == Blocks.field_150424_aL || block == Blocks.field_150343_Z || block == Blocks.field_196814_hQ || block == Blocks.field_150425_aM || block == Blocks.field_235336_cN_ || block == Blocks.field_196653_dH || block == Blocks.field_189880_di || block == Blocks.field_189878_dg || block == Blocks.field_235334_I_ || block == Blocks.field_235398_nh_ || block == Blocks.field_196766_fg || block == Blocks.field_196817_hS || block == Blocks.field_235393_nG_ || block == Blocks.field_235337_cO_ || block == Blocks.field_235338_cP_ || block == Blocks.field_235394_nH_ || block == Blocks.field_235406_np_ || block == Blocks.field_235413_nw_ || block == Blocks.field_235387_nA_ || block == Blocks.field_235410_nt_ || block == Blocks.field_235412_nv_ || block == Blocks.field_235381_mu_ || block == Blocks.field_235379_ms_ || block == Blocks.field_235374_mn_ || block == Blocks.field_150351_n || block == Blocks.field_150426_aN || block == Blocks.field_235411_nu_ || block == Blocks.field_235372_ml_ || block == Blocks.field_235383_mw_;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_LAVA, (Object)true);
    }

    public void func_70619_bc() {
        if (this.func_70605_aq().func_75640_a()) {
            double d0 = this.func_70605_aq().func_75638_b();
            if (d0 == 0.6) {
                this.func_226284_e_(true);
                this.func_70031_b(false);
            } else if (d0 == 1.33) {
                this.func_226284_e_(false);
                this.func_70031_b(true);
            } else {
                this.func_226284_e_(false);
                this.func_70031_b(false);
            }
        } else {
            this.func_226284_e_(false);
            this.func_70031_b(false);
        }
    }

    public boolean func_213397_c(double distance) {
        return !this.func_70909_n() && this.field_70173_aa > 2400;
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 2.0);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.func_70909_n()) {
            if (this.func_70880_s()) {
                return ModSounds.LAVA_CAT_PURR.get();
            }
            return this.field_70146_Z.nextInt(4) == 0 ? ModSounds.LAVA_CAT_PURREOW.get() : ModSounds.LAVA_CAT_AMBIENT.get();
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.LAVA_CAT_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.LAVA_CAT_DEATH.get();
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public boolean func_70652_k(Entity entityIn) {
        EntityDamageSource damage = new EntityDamageSource("mob", (Entity)this);
        damage.func_76351_m();
        float amount = 3.0f;
        if (this.getIsLava()) {
            damage.func_76361_j().func_76348_h();
        } else {
            amount = 6.0f;
        }
        return entityIn.func_70097_a((DamageSource)damage, amount);
    }

    public void func_70015_d(int seconds) {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        this.func_233687_w_(false);
        if (source.func_76347_k()) {
            return false;
        }
        if (source == DamageSource.field_82727_n || source == DamageSource.field_82728_o) {
            return false;
        }
        boolean lava = this.getIsLava();
        if (!lava && !source.func_82725_o()) {
            amount /= 2.0f;
        }
        if (lava && source.func_82725_o()) {
            amount /= 2.0f;
        }
        if (this.func_70909_n() && source.func_76346_g() != null && source.func_76346_g() == this.func_70902_q() && !source.func_76346_g().func_225608_bj_()) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_195064_c(EffectInstance potioneffectIn) {
        Effect type = potioneffectIn.func_188419_a();
        if (type == Effects.field_76436_u || type == Effects.field_82731_v) {
            return false;
        }
        return super.func_195064_c(potioneffectIn);
    }

    public ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (this.field_70170_p.field_72995_K) {
            boolean flag = this.func_152114_e((LivingEntity)player) || this.func_70909_n() || item == Items.field_151072_bj && !this.func_70909_n();
            return flag ? ActionResultType.CONSUME : ActionResultType.PASS;
        }
        if (this.func_70909_n()) {
            if (this.func_70877_b(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                this.func_70691_i(2.0f);
                return ActionResultType.SUCCESS;
            }
            ActionResultType actionresulttype = super.func_230254_b_(player, hand);
            if ((!actionresulttype.func_226246_a_() || this.func_70631_g_()) && this.func_152114_e((LivingEntity)player)) {
                this.func_233687_w_(!this.func_233685_eM_());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                return ActionResultType.SUCCESS;
            }
            return actionresulttype;
        }
        if (item == Items.field_151072_bj) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                this.func_193101_c(player);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.func_233687_w_(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        LavaCatEntity lavacat = (LavaCatEntity)ModEntities.LAVA_CAT.get().func_200721_a(ageable.field_70170_p);
        if (this.func_70909_n() && lavacat != null) {
            lavacat.func_184754_b(this.func_184753_b());
            lavacat.func_70903_f(true);
            lavacat.setIsLava(this.getIsLava());
        }
        return lavacat;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151065_br;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof LavaCatEntity)) {
            return false;
        }
        LavaCatEntity lavacat = (LavaCatEntity)otherAnimal;
        if (!lavacat.func_70909_n()) {
            return false;
        }
        return this.func_70880_s() && lavacat.func_70880_s();
    }

    public boolean getIsLava() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_LAVA);
    }

    public void setIsLava(boolean val) {
        this.field_70180_af.func_187227_b(IS_LAVA, (Object)val);
        ModifiableAttributeInstance instance = this.func_110148_a(Attributes.field_233821_d_);
        if (instance != null) {
            if (val && instance.func_180374_a(OBSIDIAN_SPEED)) {
                instance.func_111124_b(OBSIDIAN_SPEED);
            } else if (!instance.func_180374_a(OBSIDIAN_SPEED)) {
                instance.func_233767_b_(OBSIDIAN_SPEED);
            }
        }
    }

    protected void func_175544_ck() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getIsLava() && this.field_70170_p.func_175727_C(this.func_233580_cy_()) && this.field_70170_p.func_175710_j(this.func_233580_cy_()) && this.field_70146_Z.nextInt(30) == 0) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), ModSounds.LAVA_CAT_SIZZLE.get(), SoundCategory.NEUTRAL, 0.2f, 1.3f);
        }
        if (this.getIsLava() && this.field_70171_ac) {
            this.setIsLava(false);
        } else if (!this.getIsLava() && this.func_180799_ab()) {
            this.setIsLava(true);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsLava", this.getIsLava());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setIsLava(compound.func_74767_n("IsLava"));
    }

    public ITextComponent func_200200_C_() {
        ITextComponent itextcomponent = this.func_200201_e();
        if (itextcomponent != null) {
            return super.func_200200_C_();
        }
        if (this.getIsLava()) {
            return new TranslationTextComponent("mysticalworld.entity.lava_cat");
        }
        return new TranslationTextComponent("mysticalworld.entity.obsidian_cat");
    }
}

