/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.config;

import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import mysticmods.mysticalworld.config.FeatureConfig;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public class TreeConfig
extends FeatureConfig<TreeConfig> {
    private final double chance;
    private final List<RegistryKey<World>> dimensions;
    private ForgeConfigSpec.DoubleValue configChance;
    private ForgeConfigSpec.ConfigValue<List<? extends String>> configDimensions;
    private Set<RegistryKey<World>> storedDimension = null;

    public TreeConfig(double chance, List<BiomeDictionary.Type> biomeTypes, List<BiomeDictionary.Type> biomeRestrictions, List<RegistryKey<World>> dimensions) {
        super(biomeTypes, biomeRestrictions);
        this.chance = chance;
        this.dimensions = dimensions;
    }

    public double getChance() {
        return (Double)this.configChance.get();
    }

    public Set<RegistryKey<World>> getDimensions() {
        if (this.storedDimension == null) {
            this.storedDimension = ((List)this.configDimensions.get()).stream().map(o -> RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(o))).collect(Collectors.toSet());
        }
        return this.storedDimension;
    }

    @Override
    public boolean shouldSpawn() {
        return this.getChance() != 0.0;
    }

    @Override
    public GenerationStage.Decoration getStage() {
        return GenerationStage.Decoration.VEGETAL_DECORATION;
    }

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
        builder.comment("Charred Tree Generation").push("charred_tree");
        this.configChance = builder.comment("Number of charred trees per chunk (set to 0 to disable).").defineInRange("chance", this.chance, 0.0, 256.0);
        StringJoiner sb = new StringJoiner(",");
        this.biomes.forEach(o -> sb.add(o.getName()));
        this.configBiomes = builder.comment("List of biome types to spawn (default [" + sb.toString() + "], pass empty list for every biome").define("biomes", (Object)sb.toString());
        StringJoiner sb2 = new StringJoiner(",");
        this.biomeRestrictions.forEach(biome -> sb2.add(biome.getName()));
        this.configBiomeRestrictions = builder.comment("Which biome types this tree shouldn't spawn in (default END, NETHER)").define("biomeRestrictions", (Object)sb2.toString());
        this.configDimensions = builder.comment("The dimensions that this feature should spawn in as a list (default [\"minecraft:overworld\"])").defineList("dimensions", this.dimensions.stream().map(RegistryKey::func_240901_a_).map(ResourceLocation::toString).collect(Collectors.toList()), o -> o instanceof String);
        builder.pop();
    }

    @Override
    public void reset() {
        super.reset();
        this.storedDimension = null;
    }
}

