/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.config;

import java.util.List;
import java.util.StringJoiner;
import mysticmods.mysticalworld.config.FeatureConfig;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public class StructureConfig
extends FeatureConfig<StructureConfig> {
    private final String name;

    public StructureConfig(String name, List<BiomeDictionary.Type> biomeTypes, List<BiomeDictionary.Type> biomeRestrictions) {
        super(biomeTypes, biomeRestrictions);
        this.name = name;
    }

    @Override
    public GenerationStage.Decoration getStage() {
        return null;
    }

    @Override
    public boolean isFeature() {
        return false;
    }

    @Override
    public boolean shouldSpawn() {
        return true;
    }

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
        builder.comment("Structure Generation").push(this.name);
        StringJoiner sb = new StringJoiner(",");
        this.biomes.forEach(o -> sb.add(o.getName()));
        this.configBiomes = builder.comment("List of biome types to spawn (default [" + sb.toString() + "], pass empty list for every biome").define("biomes", (Object)sb.toString());
        StringJoiner sb2 = new StringJoiner(",");
        this.biomeRestrictions.forEach(biome -> sb2.add(biome.getName()));
        this.configBiomeRestrictions = builder.comment("Which biome types this structure shouldn't spawn in (default END, NETHER)").define("biomeRestrictions", (Object)sb2.toString());
        builder.pop();
    }
}

