/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.config;

import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import mysticmods.mysticalworld.config.FeatureConfig;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public class StonepetalConfig
extends FeatureConfig<StonepetalConfig> {
    private final int repeats;
    private final int tries;
    private final List<RegistryKey<World>> dimensions;
    private ForgeConfigSpec.IntValue configRepeats;
    private ForgeConfigSpec.IntValue configTries;
    private ForgeConfigSpec.ConfigValue<List<? extends String>> configDimensions;
    private Set<RegistryKey<World>> storedDimension = null;

    public StonepetalConfig(int repeats, int tries, List<BiomeDictionary.Type> biomeTypes, List<BiomeDictionary.Type> biomeRestrictions, List<RegistryKey<World>> dimensions) {
        super(biomeTypes, biomeRestrictions);
        this.tries = tries;
        this.repeats = repeats;
        this.dimensions = dimensions;
    }

    public int getRepeats() {
        return (Integer)this.configRepeats.get();
    }

    public int getTries() {
        return (Integer)this.configTries.get();
    }

    @Override
    public boolean shouldSpawn() {
        return this.getTries() != 0;
    }

    @Override
    public GenerationStage.Decoration getStage() {
        return GenerationStage.Decoration.VEGETAL_DECORATION;
    }

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
        builder.comment("Stonepetal Patch Generation").push("stone_petal");
        this.configTries = builder.comment("Number of tries per chunk to try placing stonepetals on stone (set to 0 to disable).").defineInRange("tries", this.tries, 0, 256);
        this.configRepeats = builder.comment("Number of times per chunk to repeat trying to place stonepetals on stone").defineInRange("repeats", this.repeats, 1, 256);
        StringJoiner sb = new StringJoiner(",");
        this.biomes.forEach(o -> sb.add(o.getName()));
        this.configBiomes = builder.comment("List of biome types to spawn (default [" + sb.toString() + "], pass empty list for every biome").define("biomes", (Object)sb.toString());
        StringJoiner sb2 = new StringJoiner(",");
        this.biomeRestrictions.forEach(biome -> sb2.add(biome.getName()));
        this.configBiomeRestrictions = builder.comment("Which biome types this tree shouldn't spawn in (default END, NETHER)").define("biomeRestrictions", (Object)sb2.toString());
        this.configDimensions = builder.comment("The dimensions that this feature should spawn in as a list (default [\"minecraft:overworld\"])").defineList("dimensions", this.dimensions.stream().map(RegistryKey::func_240901_a_).map(ResourceLocation::toString).collect(Collectors.toList()), o -> o instanceof String);
        builder.pop();
    }

    @Override
    public void reset() {
        super.reset();
        this.storedDimension = null;
    }

    public Set<RegistryKey<World>> getDimensions() {
        if (this.storedDimension == null) {
            this.storedDimension = ((List)this.configDimensions.get()).stream().map(o -> RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(o))).collect(Collectors.toSet());
        }
        return this.storedDimension;
    }
}

