/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.config;

import mysticmods.mysticalworld.config.AbstractConfig;
import net.minecraftforge.common.ForgeConfigSpec;

public class SilkwormConfig
extends AbstractConfig {
    private final boolean leafDrops;
    private final int leafDropChance;
    private final int successChance;
    private final int growthChance;
    private ForgeConfigSpec.BooleanValue configLeafDrops;
    private ForgeConfigSpec.ConfigValue<Integer> configLeafDropChance;
    private ForgeConfigSpec.ConfigValue<Integer> configSuccessChance;
    private ForgeConfigSpec.ConfigValue<Integer> configGrowthChance;
    private int cachedLeaf = -9999;
    private int cachedDrop = -9999;
    private int cachedSuccess = -9999;
    private int cachedGrowth = -9999;

    public SilkwormConfig(boolean leafDrops, int leafDropChance, int successChance, int growthChance) {
        this.leafDrops = leafDrops;
        this.leafDropChance = leafDropChance;
        this.successChance = successChance;
        this.growthChance = growthChance;
    }

    public boolean getLeafDropsEnabled() {
        if (this.cachedDrop == -9999) {
            this.cachedDrop = (Boolean)this.configLeafDrops.get() != false ? 1 : 0;
        }
        return this.cachedDrop == 1;
    }

    public int getLeafDropChance() {
        if (this.cachedLeaf == -9999) {
            this.cachedLeaf = (Integer)this.configLeafDropChance.get();
        }
        return this.cachedLeaf;
    }

    public int getSuccessChance() {
        if (this.cachedSuccess == -9999) {
            this.cachedSuccess = (Integer)this.configSuccessChance.get();
        }
        return this.cachedSuccess;
    }

    public int getGrowthChance() {
        if (this.cachedGrowth == -9999) {
            this.cachedGrowth = (Integer)this.configGrowthChance.get();
        }
        return this.cachedGrowth;
    }

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
        builder.comment("Silkworm spawn config.").push("silkworm_spawn");
        this.configLeafDrops = builder.comment("Whether or not silkworm eggs drop from leaves").define("leafDrops", this.leafDrops);
        this.configLeafDropChance = builder.comment("Chance to spawn whenever a leaf is broken (1 in X)").define("leafDropChance", (Object)this.leafDropChance);
        this.configSuccessChance = builder.comment("Chance for silkworm eggs to spawn a silkworm (1 in X, 1 is guaranteed)").define("successChance", (Object)this.successChance);
        this.configGrowthChance = builder.comment("Chance per tick for silkworms to grown (1 in X)").define("growthChance", (Object)this.growthChance);
        builder.pop();
    }

    @Override
    public void reset() {
        this.cachedLeaf = -9999;
        this.cachedDrop = -9999;
        this.cachedSuccess = -9999;
        this.cachedGrowth = -9999;
    }
}

