/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.config;

import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mysticmods.mysticalworld.config.AbstractConfig;
import mysticmods.mysticalworld.repack.noobutil.block.BaseBlocks;
import mysticmods.mysticalworld.repack.registrate.util.entry.RegistryEntry;
import mysticmods.mysticalworld.world.test.OreGenTest;
import net.minecraft.block.Block;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraftforge.common.ForgeConfigSpec;

public class OreConfig
extends AbstractConfig {
    private final String name;
    private final int chance;
    private final int minY;
    private final int maxY;
    private final int size;
    private final List<RegistryKey<World>> dimensions;
    private final Supplier<RegistryEntry<BaseBlocks.OreBlock>> ore;
    private ForgeConfigSpec.IntValue configChance;
    private ForgeConfigSpec.IntValue configMinY;
    private ForgeConfigSpec.IntValue configMaxY;
    private ForgeConfigSpec.IntValue configSize;
    private ForgeConfigSpec.ConfigValue<List<? extends String>> configDimensions;
    private final RuleTest rule;
    private Set<RegistryKey<World>> storedDimension = null;

    public OreConfig(String name, int chance, int minY, int maxY, int size, List<RegistryKey<World>> dimensions, Supplier<RegistryEntry<BaseBlocks.OreBlock>> ore) {
        this(name, chance, minY, maxY, size, dimensions, ore, OreGenTest.INSTANCE);
    }

    public OreConfig(String name, int chance, int minY, int maxY, int size, List<RegistryKey<World>> dimensions, Supplier<RegistryEntry<BaseBlocks.OreBlock>> ore, RuleTest test) {
        this.name = name;
        this.chance = chance;
        this.minY = minY;
        this.maxY = maxY;
        this.size = size;
        this.ore = ore;
        this.dimensions = dimensions;
        this.rule = test;
    }

    public String getName() {
        return this.name;
    }

    public int getChance() {
        return (Integer)this.configChance.get();
    }

    public int getMinY() {
        return (Integer)this.configMinY.get();
    }

    public int getMaxY() {
        return (Integer)this.configMaxY.get();
    }

    public int getSize() {
        return (Integer)this.configSize.get();
    }

    public Block getOre() {
        return (Block)this.ore.get().get();
    }

    public RuleTest getRule() {
        return this.rule;
    }

    public ResourceLocation getOreKey() {
        return this.ore.get().getId();
    }

    public Set<RegistryKey<World>> getDimensions() {
        if (this.storedDimension == null) {
            this.storedDimension = ((List)this.configDimensions.get()).stream().map(o -> RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(o))).collect(Collectors.toSet());
        }
        return this.storedDimension;
    }

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
        builder.comment(this.name + " ore generation.").push(this.name + "_oregen");
        this.configChance = builder.comment("Number of veins per chunk (set to 0 to disable).").defineInRange("oreChances", this.chance, 0, 256);
        this.configSize = builder.comment("Max size of the vein.").defineInRange("veinSize", this.size, 1, 256);
        this.configMinY = builder.comment("Number of veins per chunk (set to 0 to disable).").defineInRange("minY", this.minY, 0, 256);
        this.configMaxY = builder.comment("Number of veins per chunk (set to 0 to disable).").defineInRange("maxY", this.maxY, 0, 256);
        this.configDimensions = builder.comment("The dimensions that this ore should spawn in as a list (default [\"minecraft:overworld\"])").defineList("dimensions", this.dimensions.stream().map(RegistryKey::func_240901_a_).map(ResourceLocation::toString).collect(Collectors.toList()), o -> o instanceof String);
        builder.pop();
    }

    @Override
    public void reset() {
        this.storedDimension = null;
    }
}

