/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.config;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mysticmods.mysticalworld.config.AbstractConfig;
import net.minecraft.entity.EntityClassification;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public class MobConfig
extends AbstractConfig {
    protected String name;
    protected int chance;
    protected int min;
    protected int max;
    protected List<String> biomes;
    protected BiomeDictionary.Type restriction;
    protected ForgeConfigSpec.IntValue configChance;
    protected ForgeConfigSpec.IntValue configMin;
    protected ForgeConfigSpec.IntValue configMax;
    protected ForgeConfigSpec.ConfigValue<String> configBiomes;
    private List<BiomeDictionary.Type> cachedBiomes = null;

    public MobConfig(String name, int chance, int min, int max, List<String> biomes) {
        this(name, chance, min, max, biomes, BiomeDictionary.Type.OVERWORLD);
    }

    public EntityClassification getClassification() {
        return EntityClassification.CREATURE;
    }

    public MobConfig(String name, int chance, int min, int max, List<String> biomes, BiomeDictionary.Type restriction) {
        this.name = name;
        this.chance = chance;
        this.min = min;
        this.max = max;
        this.biomes = biomes;
        this.restriction = restriction;
    }

    public BiomeDictionary.Type getRestriction() {
        return this.restriction;
    }

    public int getChance() {
        return (Integer)this.configChance.get();
    }

    public int getMin() {
        return (Integer)this.configMin.get();
    }

    public int getMax() {
        return (Integer)this.configMax.get();
    }

    public List<BiomeDictionary.Type> getBiomes() {
        if (this.cachedBiomes == null) {
            this.cachedBiomes = Stream.of(((String)this.configBiomes.get()).split(",")).map(o -> BiomeDictionary.Type.getType((String)o, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])).collect(Collectors.toList());
        }
        return this.cachedBiomes;
    }

    public boolean shouldRegister() {
        return this.getChance() > 0;
    }

    protected void preApply(ForgeConfigSpec.Builder builder) {
    }

    protected void doApply(ForgeConfigSpec.Builder builder) {
        builder.comment(this.name + " spawn config.").push(this.name + "_spawn");
        this.configChance = builder.comment("Chance to spawn (set to 0 to disable).").defineInRange("spawnChance", this.chance, 0, 256);
        this.configMin = builder.comment("Min to spawn in a group.").defineInRange("min", this.min, 0, 256);
        this.configMax = builder.comment("Max to spawn in a group.").defineInRange("max", this.max, 0, 256);
        StringBuilder sb = new StringBuilder();
        this.biomes.forEach(biome -> {
            sb.append((String)biome);
            sb.append(",");
        });
        this.configBiomes = builder.comment("List of biome types to spawn.").define("biomes", (Object)sb.toString());
    }

    protected void postApply(ForgeConfigSpec.Builder builder) {
        builder.pop();
    }

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
        this.preApply(builder);
        this.doApply(builder);
        this.postApply(builder);
    }

    @Override
    public void reset() {
        this.cachedBiomes = null;
    }
}

