/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.config;

import mysticmods.mysticalworld.config.AbstractConfig;
import net.minecraftforge.common.ForgeConfigSpec;

public class HatConfig
extends AbstractConfig {
    protected ForgeConfigSpec.IntValue configAntlerFrequency;
    protected ForgeConfigSpec.IntValue configAntlerThreshold;
    protected ForgeConfigSpec.DoubleValue configAntlerHealing;
    protected ForgeConfigSpec.IntValue configAntlerRegenDuration;
    protected ForgeConfigSpec.IntValue configAntlerRegenAmplifier;
    protected ForgeConfigSpec.DoubleValue configAntlerHealthBonus;
    protected ForgeConfigSpec.IntValue configAntlerDamage;
    protected ForgeConfigSpec.IntValue configMaskChance;
    protected ForgeConfigSpec.IntValue configMaskDamage;
    protected ForgeConfigSpec.IntValue configMaskDurability;
    protected ForgeConfigSpec.DoubleValue configMaskDamageBonus;
    public int antlerFrequency = 50;
    public int antlerThreshold = -1;
    public double antlerHealing = 2.0;
    public int antlerRegenDuration = 130;
    public int antlerRegenAmplifier = 1;
    public float antlerHealthBonus = 4.0f;
    public int antlerDamage = 1;
    public int maskChance = 4;
    public int maskAttackDamage = 1;
    public int maskDurabilityDamage = 1;
    public double maskBonusDamage = 0.3;
    public int cachedAntlerFrequency = -999;
    public int cachedAntlerThreshold = -999;
    public float cachedAntlerHealing = -999.0f;
    public int cachedAntlerRegenDuration = -999;
    public int cachedAntlerRegenAmplifier = -999;
    public float cachedAntlerHealthBonus = -999.0f;
    public int cachedAntlerDamage = -999;
    public int cachedMaskChance = -999;
    public int cachedMaskAttackDamage = -999;
    public int cachedMaskDurabilityDamage = -999;
    public double cachedMaskBonusDamage = -999.0;

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
        this.configAntlerFrequency = builder.comment("Spawn frequency (1 in X chances per tick while spawn conditions are met, -1 for not at all)").defineInRange("antler_frequency", this.antlerFrequency, 0, Integer.MAX_VALUE);
        this.configAntlerThreshold = builder.comment("How many hearts under maximum health the player needs to be for a deer to spawn (-1 for any value under maximum health").defineInRange("antler_threshold", this.antlerThreshold, -1, Integer.MAX_VALUE);
        this.configAntlerHealing = builder.comment("How much a Spirit Deer should heal for").defineInRange("antler_healing", this.antlerHealing, 0.5, Double.MAX_VALUE);
        this.configAntlerRegenDuration = builder.comment("How long a duration Regeneration should be applied for").defineInRange("antler_regen_duration", this.antlerRegenDuration, 1, Integer.MAX_VALUE);
        this.configAntlerRegenAmplifier = builder.comment("What amplifier should be applied to the Regeneration effect (0 = I, 1 = II, etc)").defineInRange("antler_regen_amplifier", this.antlerRegenAmplifier, 0, Integer.MAX_VALUE);
        this.configAntlerHealthBonus = builder.comment("How much of a health bonus wearing the hat should give (-1 for no bonus, 2 for a single heart, 4 for two hearts, etc").defineInRange("antler_health_bonus", (double)this.antlerHealthBonus, 0.5, Double.MAX_VALUE);
        this.configAntlerDamage = builder.comment("How much damage to the antler hat spawning a spirit deer causes (-1 for no damage)").defineInRange("antler_damage", this.antlerDamage, -1, Integer.MAX_VALUE);
        this.configMaskChance = builder.comment("How frequency (1 in X per melee hit) Spirit Beetles should be spawned (-1 for not at all)").defineInRange("mask_chance", this.maskChance, -1, Integer.MAX_VALUE);
        this.configMaskDamage = builder.comment("How much damage Spirit Beetles should do").defineInRange("mask_damage", this.maskAttackDamage, 1, Integer.MAX_VALUE);
        this.configMaskDurability = builder.comment("How much durability damage should be done (-1 for none) per beetle spawned").defineInRange("mask_durability", this.maskDurabilityDamage, -1, Integer.MAX_VALUE);
        this.configMaskDamageBonus = builder.comment("How much of a damage to bonus should be provided by the mask (-1 for none)").defineInRange("mask_bonus_damage", this.maskBonusDamage, -1.0, Double.MAX_VALUE);
    }

    public int getAntlerFrequency() {
        if (this.cachedAntlerFrequency == -999) {
            this.cachedAntlerFrequency = (Integer)this.configAntlerFrequency.get();
        }
        return this.cachedAntlerFrequency;
    }

    public int getAntlerThreshold() {
        if (this.cachedAntlerThreshold == -999) {
            this.cachedAntlerThreshold = (Integer)this.configAntlerThreshold.get();
        }
        return this.cachedAntlerThreshold;
    }

    public float getAntlerHealing() {
        if (this.cachedAntlerHealing == -999.0f) {
            this.cachedAntlerHealing = (float)((Double)this.configAntlerHealing.get()).doubleValue();
        }
        return this.cachedAntlerHealing;
    }

    public int getAntlerRegenDuration() {
        if (this.cachedAntlerRegenDuration == -999) {
            this.cachedAntlerRegenDuration = (Integer)this.configAntlerRegenDuration.get();
        }
        return this.cachedAntlerRegenDuration;
    }

    public int getAntlerRegenAmplifier() {
        if (this.cachedAntlerRegenAmplifier == -999) {
            this.cachedAntlerRegenAmplifier = (Integer)this.configAntlerRegenAmplifier.get();
        }
        return this.cachedAntlerRegenAmplifier;
    }

    public float getAntlerHealthBonus() {
        if (this.cachedAntlerHealthBonus == -999.0f) {
            this.cachedAntlerHealthBonus = (float)((Double)this.configAntlerHealthBonus.get()).doubleValue();
        }
        return this.cachedAntlerHealthBonus;
    }

    public int getAntlerDamage() {
        if (this.cachedAntlerDamage == -999) {
            this.cachedAntlerDamage = (Integer)this.configAntlerDamage.get();
        }
        return this.cachedAntlerDamage;
    }

    public int getMaskChance() {
        if (this.cachedMaskChance == -999) {
            this.cachedMaskChance = (Integer)this.configMaskChance.get();
        }
        return this.cachedMaskChance;
    }

    public int getMaskAttackDamage() {
        if (this.cachedMaskAttackDamage == -999) {
            this.cachedMaskAttackDamage = (Integer)this.configMaskDamage.get();
        }
        return this.cachedMaskAttackDamage;
    }

    public int getMaskDurabilityDamage() {
        if (this.cachedMaskDurabilityDamage == -999) {
            this.cachedMaskDurabilityDamage = (Integer)this.configMaskDurability.get();
        }
        return this.cachedMaskDurabilityDamage;
    }

    public double getMaskBonusDamage() {
        if (this.cachedMaskBonusDamage == -999.0) {
            this.cachedMaskBonusDamage = (Double)this.configMaskDamageBonus.get();
        }
        return this.cachedMaskBonusDamage;
    }

    @Override
    public void reset() {
        this.cachedAntlerFrequency = -999;
        this.cachedAntlerThreshold = -999;
        this.cachedAntlerHealing = -999.0f;
        this.cachedAntlerRegenDuration = -999;
        this.cachedAntlerRegenAmplifier = -999;
        this.cachedAntlerHealthBonus = -999.0f;
        this.cachedAntlerDamage = -999;
        this.cachedMaskChance = -999;
        this.cachedMaskAttackDamage = -999;
        this.cachedMaskDurabilityDamage = -999;
        this.cachedMaskBonusDamage = -999.0;
    }
}

