/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.config;

import mysticmods.mysticalworld.config.AbstractConfig;
import mysticmods.mysticalworld.repack.noobutil.config.IArmorConfig;
import net.minecraftforge.common.ForgeConfigSpec;

public class ArmorConfig
extends AbstractConfig
implements IArmorConfig {
    protected ForgeConfigSpec.IntValue configFeet;
    protected ForgeConfigSpec.IntValue configLegs;
    protected ForgeConfigSpec.IntValue configChest;
    protected ForgeConfigSpec.IntValue configHead;
    protected ForgeConfigSpec.DoubleValue configToughness;
    private int feet = -9999;
    private int legs = -9999;
    private int chest = -9999;
    private int head = -9999;
    private float toughness = -9999.0f;
    private final int defaultFeet;
    private final int defaultLegs;
    private final int defaultChest;
    private final int defaultHead;
    private final float defaultToughness;
    private final String armor;

    public ArmorConfig(String armor, int defaultFeet, int defaultLegs, int defaultChest, int defaultHead, float defaultToughness) {
        this.armor = armor;
        this.defaultFeet = defaultFeet;
        this.defaultLegs = defaultLegs;
        this.defaultChest = defaultChest;
        this.defaultHead = defaultHead;
        this.defaultToughness = defaultToughness;
    }

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
        builder.comment("Configuration for " + this.armor + " armor").push(this.armor + "_armor");
        this.configChest = builder.comment("Armor value for chest piece").defineInRange("chest_armor", this.defaultChest, 0, Integer.MAX_VALUE);
        this.configFeet = builder.comment("Armor value for feet piece").defineInRange("feet_armor", this.defaultFeet, 0, Integer.MAX_VALUE);
        this.configHead = builder.comment("Armor value for head piece").defineInRange("head_armor", this.defaultHead, 0, Integer.MAX_VALUE);
        this.configLegs = builder.comment("Armor value for legs piece").defineInRange("legs_armor", this.defaultLegs, 0, Integer.MAX_VALUE);
        this.configToughness = builder.comment("Toughness for armor made of this material").defineInRange("toughness", (double)this.defaultToughness, 0.0, Double.MAX_VALUE);
        builder.pop();
    }

    @Override
    public void reset() {
        this.feet = -9999;
        this.legs = -9999;
        this.chest = -9999;
        this.head = -9999;
        this.toughness = -9999.0f;
    }

    @Override
    public int getFeet() {
        if (this.feet == -9999) {
            this.feet = (Integer)this.configFeet.get();
        }
        return this.feet;
    }

    @Override
    public int getLegs() {
        if (this.legs == -9999) {
            this.legs = (Integer)this.configLegs.get();
        }
        return this.legs;
    }

    @Override
    public int getChest() {
        if (this.chest == -9999) {
            this.chest = (Integer)this.configChest.get();
        }
        return this.chest;
    }

    @Override
    public int getHead() {
        if (this.head == -9999) {
            this.head = (Integer)this.configHead.get();
        }
        return this.head;
    }

    @Override
    public float getToughness() {
        if (this.toughness == -9999.0f) {
            this.toughness = (float)((Double)this.configToughness.get()).doubleValue();
        }
        return this.toughness;
    }
}

