/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import javax.annotation.Nonnull;
import mysticmods.mysticalworld.client.model.EnderminiModel;
import mysticmods.mysticalworld.client.model.ModelHolder;
import mysticmods.mysticalworld.entity.EnderminiEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.AbstractEyesLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class EnderminiRenderer
extends MobRenderer<EnderminiEntity, EnderminiModel<EnderminiEntity>> {
    private static final ResourceLocation ENDERMINI_TEXTURES = new ResourceLocation("mysticalworld", "textures/entity/endermini.png");
    private final Random rnd = new Random();

    public EnderminiRenderer(EntityRendererManager renderManagerIn, EnderminiModel<EnderminiEntity> model, float size) {
        super(renderManagerIn, model, size);
        this.func_177094_a((LayerRenderer)new EnderminiEyesLayer(this));
        this.func_177094_a(new HeldBlockLayer((IEntityRenderer<EnderminiEntity, EnderminiModel<EnderminiEntity>>)this));
    }

    @Nonnull
    public Vector3d getRenderOffset(EnderminiEntity pEntity, float pPartialTicks) {
        if (pEntity.isScreaming()) {
            return new Vector3d(this.rnd.nextGaussian() * 0.02, 0.0, this.rnd.nextGaussian() * 0.02);
        }
        return super.func_225627_b_((Entity)pEntity, pPartialTicks);
    }

    public void render(EnderminiEntity pEntity, float pEntityYaw, float pPartialTicks, MatrixStack stack, IRenderTypeBuffer pBuffer, int pPackedLight) {
        BlockState blockstate = pEntity.getHeldBlockState();
        EnderminiModel<EnderminiEntity> endermanmodel = this.getModel();
        endermanmodel.field_78126_a = blockstate != null;
        endermanmodel.field_78125_b = pEntity.isScreaming();
        stack.func_227860_a_();
        stack.func_227862_a_(0.4f, 0.4f, 0.4f);
        super.func_225623_a_((MobEntity)pEntity, pEntityYaw, pPartialTicks, stack, pBuffer, pPackedLight);
        stack.func_227865_b_();
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull EnderminiEntity entity) {
        return ENDERMINI_TEXTURES;
    }

    @Nonnull
    public EnderminiModel<EnderminiEntity> getModel() {
        return ModelHolder.enderminiModel;
    }

    public static class EnderminiEyesLayer<T extends LivingEntity>
    extends AbstractEyesLayer<T, EnderminiModel<T>> {
        private static final RenderType SKIN = RenderType.func_228652_i_((ResourceLocation)new ResourceLocation("textures/entity/enderman/enderman_eyes.png"));

        public EnderminiEyesLayer(IEntityRenderer<T, EnderminiModel<T>> p_i50939_1_) {
            super(p_i50939_1_);
        }

        public RenderType func_225636_a_() {
            return SKIN;
        }
    }

    public static class HeldBlockLayer
    extends LayerRenderer<EnderminiEntity, EnderminiModel<EnderminiEntity>> {
        public HeldBlockLayer(IEntityRenderer<EnderminiEntity, EnderminiModel<EnderminiEntity>> p_i50949_1_) {
            super(p_i50949_1_);
        }

        public void render(@Nonnull MatrixStack pMatrixStack, @Nonnull IRenderTypeBuffer pBuffer, int pPackedLight, EnderminiEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            BlockState blockstate = pLivingEntity.getHeldBlockState();
            if (blockstate != null) {
                pMatrixStack.func_227860_a_();
                pMatrixStack.func_227861_a_(0.0, 0.6875, -0.75);
                pMatrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(20.0f));
                pMatrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(45.0f));
                pMatrixStack.func_227861_a_(0.25, 0.1875, 0.25);
                pMatrixStack.func_227862_a_(-0.5f, -0.5f, 0.5f);
                pMatrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                Minecraft.func_71410_x().func_175602_ab().renderBlock(blockstate, pMatrixStack, pBuffer, pPackedLight, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
                pMatrixStack.func_227865_b_();
            }
        }
    }

    public static class Factory
    implements IRenderFactory<EnderminiEntity> {
        public EntityRenderer<? super EnderminiEntity> createRenderFor(EntityRendererManager manager) {
            return new EnderminiRenderer(manager, ModelHolder.enderminiModel, 0.35f);
        }
    }
}

