/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.client.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Function;
import mysticmods.mysticalworld.client.model.ModelState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.util.ResourceLocation;

public abstract class ShoulderRidingModel<T extends Entity>
extends AgeableModel<T> {
    public ShoulderRidingModel(boolean scaleHead, float yHeadOffset, float zHeadOfset) {
        super(scaleHead, yHeadOffset, zHeadOfset);
    }

    public ShoulderRidingModel(boolean scaleHead, float yHeadOffset, float zHeadOffset, float babyHeadScale, float babyBodyScale, float bodyYOffset) {
        super(scaleHead, yHeadOffset, zHeadOffset, babyHeadScale, babyBodyScale, bodyYOffset);
    }

    public ShoulderRidingModel(Function<ResourceLocation, RenderType> renderType, boolean scaleHead, float yHeadOffset, float zHeadOffset, float babyHeadScale, float babyBodyScale, float bodyYOffset) {
        super(renderType, scaleHead, yHeadOffset, zHeadOffset, babyHeadScale, babyBodyScale, bodyYOffset);
    }

    public ShoulderRidingModel() {
    }

    public void func_225597_a_(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.setupAnim(this.getStateFor(pEntity), ((Entity)pEntity).field_70173_aa, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
    }

    public void func_212843_a_(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        this.prepare(this.getStateFor(pEntity));
    }

    public void renderOnShoulder(MatrixStack pMatrixStack, IVertexBuilder pBuffer, int pPackedLight, int pPackedOverlay, float pLimbSwing, float pLimbSwingAmount, float pNetHeadYaw, float pHeadPitch, int ticks) {
        this.prepare(ModelState.SHOULDER);
        this.setupAnim(ModelState.SHOULDER, ticks, pLimbSwing, pLimbSwingAmount, 0.0f, pNetHeadYaw, pHeadPitch);
        if (this.field_217114_e) {
            pMatrixStack.func_227860_a_();
            if (this.field_228221_a_) {
                float f = 1.5f / this.field_228224_g_;
                pMatrixStack.func_227862_a_(f, f, f);
            }
            pMatrixStack.func_227861_a_(0.0, (double)(this.field_228222_b_ / 16.0f), (double)(this.field_228223_f_ / 16.0f));
            this.func_225602_a_().forEach(part -> part.func_228308_a_(pMatrixStack, pBuffer, pPackedLight, pPackedOverlay));
            pMatrixStack.func_227865_b_();
            pMatrixStack.func_227860_a_();
            float f1 = 1.0f / this.field_228225_h_;
            pMatrixStack.func_227862_a_(f1, f1, f1);
            pMatrixStack.func_227861_a_(0.0, (double)(this.field_228226_i_ / 16.0f), 0.0);
            this.func_225600_b_().forEach(part -> part.func_228308_a_(pMatrixStack, pBuffer, pPackedLight, pPackedOverlay));
            pMatrixStack.func_227865_b_();
        } else {
            this.func_225602_a_().forEach(part -> part.func_228308_a_(pMatrixStack, pBuffer, pPackedLight, pPackedOverlay));
            this.func_225600_b_().forEach(part -> part.func_228308_a_(pMatrixStack, pBuffer, pPackedLight, pPackedOverlay));
        }
    }

    protected ModelState getStateFor(T entity) {
        if (entity instanceof TameableEntity) {
            TameableEntity tameable = (TameableEntity)entity;
            if (tameable.func_233684_eK_()) {
                return ModelState.SITTING;
            }
            return ModelState.NORMAL;
        }
        return ModelState.NORMAL;
    }

    protected abstract void setupAnim(ModelState var1, int var2, float var3, float var4, float var5, float var6, float var7);

    protected abstract void prepare(ModelState var1);

    public abstract ResourceLocation getTexture(ModelState var1);
}

