/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.client.model;

import com.google.common.collect.ImmutableSet;
import javax.annotation.Nonnull;
import mysticmods.mysticalworld.entity.OwlEntity;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OwlModel
extends AgeableModel<OwlEntity> {
    private final ModelRenderer body;
    private final ModelRenderer footR;
    private final ModelRenderer footL;
    private final ModelRenderer wingR1;
    private final ModelRenderer wingR2;
    private final ModelRenderer wingL1;
    private final ModelRenderer wingL2;
    private final ModelRenderer tail;
    private final ModelRenderer head;
    private final ModelRenderer tuftR;
    private final ModelRenderer tuftL;
    private State state = State.STANDING;

    public OwlModel() {
        super(true, 5.0f, 2.0f);
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.body = new ModelRenderer((Model)this);
        this.body.func_78793_a(0.0f, 24.0f, 0.0f);
        this.body.func_78784_a(0, 0).func_228303_a_(-4.0f, -13.0f, -4.0f, 8.0f, 9.0f, 8.0f, 0.0f, false);
        this.footR = new ModelRenderer((Model)this);
        this.footR.func_78793_a(-1.5f, -4.0f, -0.5f);
        this.body.func_78792_a(this.footR);
        this.footR.func_78784_a(0, 43).func_228303_a_(-1.5f, 0.0f, -1.5f, 3.0f, 2.0f, 3.0f, 0.0f, false);
        this.footR.func_78784_a(26, 48).func_228303_a_(-1.0f, 2.0f, 0.5f, 2.0f, 2.0f, 0.0f, 0.0f, false);
        this.footR.func_78784_a(0, 48).func_228303_a_(-1.0f, 4.0f, -1.5f, 2.0f, 0.0f, 2.0f, 0.0f, false);
        this.footL = new ModelRenderer((Model)this);
        this.footL.func_78793_a(1.5f, -4.0f, -0.5f);
        this.body.func_78792_a(this.footL);
        this.footL.func_78784_a(12, 43).func_228303_a_(-1.5f, 0.0f, -1.5f, 3.0f, 2.0f, 3.0f, 0.0f, false);
        this.footL.func_78784_a(22, 48).func_228303_a_(-1.0f, 2.0f, 0.5f, 2.0f, 2.0f, 0.0f, 0.0f, false);
        this.footL.func_78784_a(8, 48).func_228303_a_(-1.0f, 4.0f, -1.5f, 2.0f, 0.0f, 2.0f, 0.0f, false);
        this.wingR1 = new ModelRenderer((Model)this);
        this.wingR1.func_78793_a(-4.0f, -13.0f, -1.0f);
        this.body.func_78792_a(this.wingR1);
        this.wingR1.func_78784_a(16, 17).func_228303_a_(-1.0f, 0.0f, -2.0f, 1.0f, 7.0f, 7.0f, 0.0f, false);
        this.wingR2 = new ModelRenderer((Model)this);
        this.wingR2.func_78793_a(-1.0f, 7.0f, -2.0f);
        this.wingR1.func_78792_a(this.wingR2);
        this.setRotationAngle(this.wingR2, 0.1745f, 0.0349f, -0.1745f);
        this.wingR2.func_78784_a(14, 31).func_228303_a_(0.0f, 0.0f, 0.0f, 1.0f, 6.0f, 6.0f, 0.0f, false);
        this.wingL1 = new ModelRenderer((Model)this);
        this.wingL1.func_78793_a(4.0f, -13.0f, -1.0f);
        this.body.func_78792_a(this.wingL1);
        this.wingL1.func_78784_a(0, 17).func_228303_a_(0.0f, 0.0f, -2.0f, 1.0f, 7.0f, 7.0f, 0.0f, false);
        this.wingL2 = new ModelRenderer((Model)this);
        this.wingL2.func_78793_a(1.0f, 7.0f, -2.0f);
        this.wingL1.func_78792_a(this.wingL2);
        this.setRotationAngle(this.wingL2, 0.1745f, -0.0349f, 0.1745f);
        this.wingL2.func_78784_a(0, 31).func_228303_a_(-1.0f, 0.0f, 0.0f, 1.0f, 6.0f, 6.0f, 0.0f, false);
        this.tail = new ModelRenderer((Model)this);
        this.tail.func_78793_a(0.0f, -5.0f, 4.0f);
        this.body.func_78792_a(this.tail);
        this.setRotationAngle(this.tail, 0.5236f, 0.0f, 0.0f);
        this.tail.func_78784_a(28, 31).func_228303_a_(-3.0f, 0.0f, -2.0f, 6.0f, 4.0f, 2.0f, 0.0f, false);
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(0.0f, -13.0f, 0.0f);
        this.body.func_78792_a(this.head);
        this.head.func_78784_a(32, 0).func_228303_a_(-3.5f, -6.0f, -3.5f, 7.0f, 6.0f, 7.0f, 0.0f, false);
        this.head.func_78784_a(16, 48).func_228303_a_(-1.0f, -3.0f, -4.5f, 2.0f, 2.0f, 1.0f, 0.0f, false);
        this.tuftR = new ModelRenderer((Model)this);
        this.tuftR.func_78793_a(-2.0f, -6.0f, -3.0f);
        this.head.func_78792_a(this.tuftR);
        this.setRotationAngle(this.tuftR, 0.4363f, -0.3491f, 0.0f);
        this.tuftR.func_78784_a(24, 43).func_228303_a_(-2.0f, 0.0f, 0.0f, 2.0f, 0.0f, 4.0f, 0.0f, false);
        this.tuftL = new ModelRenderer((Model)this);
        this.tuftL.func_78793_a(2.0f, -6.0f, -3.0f);
        this.head.func_78792_a(this.tuftL);
        this.setRotationAngle(this.tuftL, 0.4363f, 0.3491f, 0.0f);
        this.tuftL.func_78784_a(36, 43).func_228303_a_(0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 4.0f, 0.0f, false);
    }

    @Nonnull
    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableSet.of();
    }

    @Nonnull
    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableSet.of((Object)this.body);
    }

    public void setupAnim(OwlEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.head.field_78808_h = 0.0f;
        boolean hootfire = false;
        if (entityIn.func_145818_k_() && entityIn.func_200201_e() != null && entityIn.func_200201_e().getString().equals("Hootfire")) {
            hootfire = true;
        }
        if (this.state == State.FLYING && !hootfire) {
            this.setRotationAngle(this.body, 0.45f, 0.0f, 0.0f);
            this.setRotationAngle(this.footR, 0.25f, 0.0f, 0.0f);
            this.setRotationAngle(this.footL, 0.25f, 0.0f, 0.0f);
            this.setRotationAngle(this.tail, 0.15f, 0.0f, 0.0f);
            this.setRotationAngle(this.head, -0.3f, 0.0f, 0.0f);
            float wingR_rotation = -(0.65f * (float)Math.sin(ageInTicks) - 1.625f);
            float wingL_rotation = 0.65f * (float)Math.sin(ageInTicks) - 1.625f;
            this.setRotationAngle(this.wingR1, 0.45f, 0.0f, wingR_rotation);
            this.setRotationAngle(this.wingL1, 0.45f, 0.0f, wingL_rotation);
            this.setRotationAngle(this.wingR2, 0.45f, 0.0f, 0.05f * wingR_rotation);
            this.setRotationAngle(this.wingL2, 0.45f, 0.0f, 0.05f * wingL_rotation);
        } else {
            this.setRotationAngle(this.body, 0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.footR, 0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.footL, 0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.tail, 0.5236f, 0.0f, 0.0f);
            this.setRotationAngle(this.head, 0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.wingR1, 0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.wingR2, 0.1745f, 0.0349f, -0.1745f);
            this.setRotationAngle(this.wingL1, 0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.wingL2, 0.1745f, -0.0349f, 0.1745f);
        }
    }

    public void prepareMobModel(OwlEntity owl, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.state = owl.isFlying() ? State.FLYING : State.STANDING;
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum State {
        FLYING,
        STANDING,
        SITTING;

    }
}

