/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.blocks;

import javax.annotation.Nullable;
import mysticmods.mysticalworld.repack.noobutil.util.VoxelUtil;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;

public class BonesBlock
extends HorizontalBlock {
    private static final VoxelShape bone_pile_south_shape = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0);
    private static final VoxelShape bone_pile_north_shape = VoxelUtil.rotateHorizontal(bone_pile_south_shape, Direction.SOUTH);
    private static final VoxelShape bone_pile_west_shape = VoxelUtil.rotateHorizontal(bone_pile_south_shape, Direction.EAST);
    private static final VoxelShape bone_pile_east_shape = VoxelUtil.rotateHorizontal(bone_pile_south_shape, Direction.WEST);
    private static final VoxelShape skeleton_south_shape = Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)8.0, (double)16.0);
    private static final VoxelShape skeleton_north_shape = VoxelUtil.rotateHorizontal(skeleton_south_shape, Direction.SOUTH);
    private static final VoxelShape skeleton_west_shape = VoxelUtil.rotateHorizontal(skeleton_south_shape, Direction.EAST);
    private static final VoxelShape skeleton_east_shapes = VoxelUtil.rotateHorizontal(skeleton_south_shape, Direction.WEST);
    private final BoneType type;

    public BonesBlock(AbstractBlock.Properties p_i48377_1_, BoneType type) {
        super(p_i48377_1_);
        this.type = type;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)field_185512_D, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)field_185512_D)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return this.func_185499_a(state, mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)field_185512_D)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D});
    }

    public VoxelShape func_220053_a(BlockState pState, IBlockReader pLevel, BlockPos pPos, ISelectionContext pContext) {
        Direction facing = (Direction)pState.func_177229_b((Property)field_185512_D);
        VoxelShape shape = null;
        switch (this.type) {
            case BOTTOM: 
            case TOP: {
                switch (facing) {
                    case EAST: {
                        shape = skeleton_east_shapes;
                        break;
                    }
                    case WEST: {
                        shape = skeleton_west_shape;
                        break;
                    }
                    case SOUTH: {
                        shape = skeleton_south_shape;
                        break;
                    }
                    case NORTH: {
                        shape = skeleton_north_shape;
                    }
                }
                break;
            }
            case PILE: {
                switch (facing) {
                    case EAST: {
                        shape = bone_pile_east_shape;
                        break;
                    }
                    case WEST: {
                        shape = bone_pile_west_shape;
                        break;
                    }
                    case SOUTH: {
                        shape = bone_pile_south_shape;
                        break;
                    }
                    case NORTH: {
                        shape = bone_pile_north_shape;
                    }
                }
                break;
            }
            default: {
                shape = bone_pile_south_shape;
            }
        }
        if (shape == null) {
            return bone_pile_south_shape;
        }
        return shape;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext pContext) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)pContext.func_195992_f().func_176734_d());
    }

    public static enum BoneType {
        PILE,
        TOP,
        BOTTOM;

    }
}

