/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld;

import mysticmods.mysticalworld.config.ConfigManager;
import mysticmods.mysticalworld.events.LeafHandler;
import mysticmods.mysticalworld.events.global.GrassHandler;
import mysticmods.mysticalworld.gen.LootTableGenerator;
import mysticmods.mysticalworld.gen.PotionTagGenerator;
import mysticmods.mysticalworld.init.ModBlocks;
import mysticmods.mysticalworld.init.ModEffects;
import mysticmods.mysticalworld.init.ModEntities;
import mysticmods.mysticalworld.init.ModFeatures;
import mysticmods.mysticalworld.init.ModItems;
import mysticmods.mysticalworld.init.ModLang;
import mysticmods.mysticalworld.init.ModLoot;
import mysticmods.mysticalworld.init.ModModifiers;
import mysticmods.mysticalworld.init.ModRecipes;
import mysticmods.mysticalworld.init.ModSounds;
import mysticmods.mysticalworld.init.ModTags;
import mysticmods.mysticalworld.integration.dynamictrees.DynamicTrees;
import mysticmods.mysticalworld.repack.noobutil.data.generator.RecipeGenerator;
import mysticmods.mysticalworld.repack.noobutil.modifier.PlayerModifierRegistry;
import mysticmods.mysticalworld.repack.noobutil.recipe.UniqueShapelessRecipe;
import mysticmods.mysticalworld.repack.noobutil.reference.ModData;
import mysticmods.mysticalworld.repack.noobutil.registrate.CustomRegistrate;
import mysticmods.mysticalworld.repack.registrate.util.nullness.NonNullSupplier;
import mysticmods.mysticalworld.setup.ClientInit;
import mysticmods.mysticalworld.setup.CommonSetup;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mysticalworld")
public class MysticalWorld {
    public static PlantType STONE_PLANT;
    public static final Logger LOG;
    public static final String MODID = "mysticalworld";
    public static CustomRegistrate REGISTRATE;
    public static RecipeGenerator RECIPES;
    public static final ItemGroup ITEM_GROUP;

    public MysticalWorld() {
        ModData.setIdAndIdentifier(MODID, "MysticalWorld");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigManager.COMMON_CONFIG);
        ConfigManager.loadConfig(ConfigManager.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("mysticalworld-common.toml"));
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::onDataGen);
        REGISTRATE = CustomRegistrate.create(MODID);
        REGISTRATE.itemGroup(NonNullSupplier.of(() -> ITEM_GROUP));
        ModBlocks.load();
        ModItems.load();
        ModEntities.load();
        ModRecipes.load();
        ModModifiers.load();
        ModSounds.load();
        ModEffects.load();
        ModLang.load();
        ModTags.load();
        ModFeatures.load();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientInit::init);
        modBus.addListener(CommonSetup::init);
        modBus.addListener(CommonSetup::loadComplete);
        modBus.addListener(ModEntities::registerAttributes);
        modBus.addGenericListener(GlobalLootModifierSerializer.class, GrassHandler::registerModifiers);
        MinecraftForge.EVENT_BUS.addListener(CommonSetup::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(CommonSetup::serverAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(LeafHandler::onBlockDrops);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, ModFeatures::onBiomeLoad);
        MinecraftForge.EVENT_BUS.addListener(ModFeatures::onWorldLoad);
        CommonSetup.registerListeners();
        modBus.addListener(ConfigManager::configReload);
        PlayerModifierRegistry.addModifier(ModModifiers.SERENDIPITY);
        PlayerModifierRegistry.addModifier(ModModifiers.BLESSED);
        PlayerModifierRegistry.addModifier(ModModifiers.SMITE);
        PlayerModifierRegistry.addModifier(ModModifiers.CARAPAX);
        if (ModList.get().isLoaded("dynamictrees")) {
            DynamicTrees.init();
        }
    }

    public void onDataGen(GatherDataEvent event) {
        if (event.includeServer()) {
            ModLoot.load();
            ModLoot.CONDITION_REGISTRY.registration();
            ModLoot.FUNCTION_REGISTRY.registration();
            UniqueShapelessRecipe.setStoredSerializer((IRecipeSerializer)ModRecipes.UNIQUE_SHAPELESS_RECIPE.get());
            event.getGenerator().func_200390_a((IDataProvider)new LootTableGenerator(event.getGenerator()));
            event.getGenerator().func_200390_a((IDataProvider)new PotionTagGenerator(event.getGenerator(), event.getExistingFileHelper()));
        }
    }

    static {
        LOG = LogManager.getLogger();
        RECIPES = new RecipeGenerator(MODID);
        ITEM_GROUP = new ItemGroup(MODID){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)ModBlocks.SAPPHIRE_BLOCK.get());
            }
        };
    }
}

