/*
 * Decompiled with CFR 0.152.
 */
package cofh.archersparadox.entity.projectile;

import cofh.archersparadox.init.APReferences;
import cofh.lib.util.AreaUtils;
import cofh.lib.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class MagmaArrowEntity
extends AbstractArrowEntity {
    private static float DAMAGE = 0.5f;
    private static final int DURATION = 5;
    private static int KNOCKBACK = 3;
    private static int KNOCKBACK_FACTOR = 1;
    private static float MAX_VELOCITY = 3.0f;
    private static float MIN_VELOCITY = 0.5f;
    private static final int RADIUS = 2;
    private int bounces = 0;
    private int maxBounces = KNOCKBACK;

    public MagmaArrowEntity(EntityType<? extends MagmaArrowEntity> entityIn, World worldIn) {
        super(entityIn, worldIn);
        this.field_70255_ao = DAMAGE;
        this.field_70256_ap = KNOCKBACK;
    }

    public MagmaArrowEntity(World worldIn, LivingEntity shooter) {
        super(APReferences.MAGMA_ARROW_ENTITY, shooter, worldIn);
        this.field_70255_ao = DAMAGE;
        this.field_70256_ap = KNOCKBACK;
    }

    public MagmaArrowEntity(World worldIn, double x, double y, double z) {
        super(APReferences.MAGMA_ARROW_ENTITY, x, y, z, worldIn);
        this.field_70255_ao = DAMAGE;
        this.field_70256_ap = KNOCKBACK;
    }

    protected ItemStack func_184550_j() {
        return new ItemStack((IItemProvider)Items.field_151032_g);
    }

    protected void func_70227_a(RayTraceResult raytraceResultIn) {
        if (raytraceResultIn.func_216346_c() != RayTraceResult.Type.MISS) {
            this.func_213869_a(SoundEvents.field_187764_dj);
            AreaUtils.igniteNearbyEntities((Entity)this, (World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), (int)2, (int)5);
            AreaUtils.igniteNearbyGround((Entity)this, (World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), (int)2, (double)0.1);
            if (raytraceResultIn.func_216346_c() == RayTraceResult.Type.ENTITY) {
                this.func_213868_a((EntityRayTraceResult)raytraceResultIn);
            } else if (raytraceResultIn.func_216346_c() == RayTraceResult.Type.BLOCK) {
                Vector3d motion = this.func_213322_ci();
                if (motion.func_189985_c() < (double)MIN_VELOCITY || this.func_70090_H() || this.bounces >= this.maxBounces) {
                    super.func_70227_a(raytraceResultIn);
                    return;
                }
                BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)raytraceResultIn;
                switch (blockraytraceresult.func_216354_b()) {
                    case DOWN: 
                    case UP: {
                        this.func_213293_j(motion.field_72450_a, motion.field_72448_b * -1.0, motion.field_72449_c);
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        this.func_213293_j(motion.field_72450_a, motion.field_72448_b, motion.field_72449_c * -1.0);
                        break;
                    }
                    case WEST: 
                    case EAST: {
                        this.func_213293_j(motion.field_72450_a * -1.0, motion.field_72448_b, motion.field_72449_c);
                    }
                }
                float f = MathHelper.func_76133_a((double)MagmaArrowEntity.func_213296_b((Vector3d)motion));
                this.field_70177_z = (float)(MathHelper.func_181159_b((double)motion.field_72450_a, (double)motion.field_72449_c) * 57.2957763671875);
                this.field_70125_A = (float)(MathHelper.func_181159_b((double)motion.field_72448_b, (double)f) * 57.2957763671875);
                this.field_70126_B = this.field_70177_z;
                this.field_70127_C = this.field_70125_A;
                ++this.bounces;
                --this.field_70256_ap;
            }
        }
    }

    protected void func_213868_a(EntityRayTraceResult raytraceResultIn) {
        super.func_213868_a(raytraceResultIn);
        Entity entity = raytraceResultIn.func_216348_a();
        if (!this.func_70090_H() && !(entity instanceof EndermanEntity)) {
            entity.func_70015_d(5);
        }
    }

    public void func_70015_d(int seconds) {
    }

    public void func_70243_d(boolean critical) {
    }

    public void func_70240_a(int knockbackStrengthIn) {
        super.func_70240_a(KNOCKBACK + knockbackStrengthIn * KNOCKBACK_FACTOR);
        this.maxBounces = this.field_70256_ap;
    }

    public void func_213872_b(byte level) {
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        super.func_70186_c(x, y, z, Math.min(velocity, MAX_VELOCITY), inaccuracy);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if ((!this.field_70254_i || this.func_203047_q()) && Utils.isClientWorld((World)this.field_70170_p)) {
            Vector3d vec3d = this.func_213322_ci();
            double d1 = vec3d.field_72450_a;
            double d2 = vec3d.field_72448_b;
            double d0 = vec3d.field_72449_c;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197595_F, this.func_226277_ct_() + d1 * 0.25, this.func_226278_cu_() + d2 * 0.25, this.func_226281_cx_() + d0 * 0.25, -d1, -d2 + 0.2, -d0);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("ArrowData", this.bounces);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.bounces = compound.func_74762_e("ArrowData");
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

