/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl_native.world;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/world/MCBiome")
@NativeTypeRegistration(value=Biome.class, zenCodeName="crafttweaker.api.world.MCBiome")
public class ExpandBiome {
    @ZenCodeType.Getter(value="waterColor")
    public static int getWaterFloat(Biome internal) {
        return internal.func_185361_o();
    }

    @ZenCodeType.Getter(value="waterFogColor")
    public static int getWaterFogColor(Biome internal) {
        return internal.func_204274_p();
    }

    @ZenCodeType.Getter(value="scale")
    public static float getScale(Biome internal) {
        return internal.func_185360_m();
    }

    @ZenCodeType.Getter(value="downfall")
    public static float getDownFall(Biome internal) {
        return internal.func_76727_i();
    }

    @ZenCodeType.Getter(value="depth")
    public static float getDepth(Biome internal) {
        return internal.func_185355_j();
    }

    @ZenCodeType.Getter(value="isHighHumidity")
    public static boolean isHighHumidity(Biome internal) {
        return internal.func_76736_e();
    }

    @ZenCodeType.Getter(value="category")
    public static String getCategory(Biome internal) {
        return internal.func_201856_r().func_222352_a().toLowerCase();
    }

    @ZenCodeType.Getter(value="doesRain")
    public static boolean doesRain(Biome internal) {
        return internal.func_201851_b() == Biome.RainType.RAIN;
    }

    @ZenCodeType.Getter(value="doesSnow")
    public static boolean doesSnow(Biome internal) {
        return internal.func_201851_b() == Biome.RainType.SNOW;
    }

    @ZenCodeType.Getter(value="rainType")
    public static String getRainType(Biome internal) {
        return internal.func_201851_b().func_222361_a();
    }

    @ZenCodeType.Method
    public static float getTemperature(Biome internal, BlockPos pos) {
        return internal.func_225486_c(pos);
    }

    @ZenCodeType.Method
    public static boolean doesWaterFreeze(Biome internal, World world, BlockPos pos) {
        return internal.func_201848_a((IWorldReader)world, pos);
    }

    @ZenCodeType.Method
    public static boolean doesWaterFreeze(Biome internal, World world, BlockPos pos, boolean mustBeAtEdge) {
        return internal.func_201854_a((IWorldReader)world, pos, mustBeAtEdge);
    }

    @ZenCodeType.Method
    public static boolean doesSnowFreeze(Biome internal, World world, BlockPos pos) {
        return internal.func_201850_b((IWorldReader)world, pos);
    }

    @ZenCodeType.Getter(value="registryName")
    public static ResourceLocation getRegistryName(Biome internal) {
        return internal.getRegistryName();
    }

    @ZenCodeType.Getter(value="commandString")
    public static String getCommandString(Biome internal) {
        return "<biome:" + internal.getRegistryName() + ">";
    }
}

