/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl_native.event;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/event/ItemAttributeModifierEvent")
@NativeTypeRegistration(value=ItemAttributeModifierEvent.class, zenCodeName="crafttweaker.api.event.ItemAttributeModifierEvent")
public class ExpandItemAttributeModifierEvent {
    @ZenCodeType.Method
    @ZenCodeType.Getter(value="modifiers")
    public static Map<Attribute, List<AttributeModifier>> getModifiers(ItemAttributeModifierEvent internal) {
        return internal.getModifiers().asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, attributeAttributeModifierEntry -> new ArrayList((Collection)attributeAttributeModifierEntry.getValue())));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="originalModifiers")
    public static Map<Attribute, List<AttributeModifier>> getOriginalModifiers(ItemAttributeModifierEvent internal) {
        return internal.getOriginalModifiers().asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, attributeAttributeModifierEntry -> new ArrayList((Collection)attributeAttributeModifierEntry.getValue())));
    }

    @ZenCodeType.Method
    public static boolean addModifier(ItemAttributeModifierEvent internal, Attribute attribute, String name, double value, AttributeModifier.Operation operation) {
        return internal.addModifier(attribute, new AttributeModifier(name, value, operation));
    }

    @ZenCodeType.Method
    public static boolean addModifier(ItemAttributeModifierEvent internal, Attribute attribute, String uuid, String name, double value, AttributeModifier.Operation operation) {
        return internal.addModifier(attribute, new AttributeModifier(UUID.fromString(uuid), name, value, operation));
    }

    @ZenCodeType.Method
    public static boolean removeModifier(ItemAttributeModifierEvent internal, Attribute attribute, String uuid) {
        boolean[] doneWork = new boolean[]{false};
        internal.getModifiers().values().stream().filter(attributeModifier -> attributeModifier.func_111167_a().equals(UUID.fromString(uuid))).forEach(attributeModifier -> {
            doneWork[0] = doneWork[0] | internal.removeModifier(attribute, attributeModifier);
        });
        return doneWork[0];
    }

    @ZenCodeType.Method
    public static boolean removeModifier(ItemAttributeModifierEvent internal, Attribute attribute, AttributeModifier modifier) {
        return internal.removeModifier(attribute, modifier);
    }

    @ZenCodeType.Method
    public static List<AttributeModifier> removeAttribute(ItemAttributeModifierEvent internal, Attribute attribute) {
        return new ArrayList<AttributeModifier>(internal.removeAttribute(attribute));
    }

    @ZenCodeType.Method
    public static void clearModifiers(ItemAttributeModifierEvent internal) {
        internal.clearModifiers();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="slotType")
    public static EquipmentSlotType getSlotType(ItemAttributeModifierEvent internal) {
        return internal.getSlotType();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="itemstack")
    public static IItemStack getItemStack(ItemAttributeModifierEvent internal) {
        return new MCItemStack(internal.getItemStack());
    }
}

