/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes.handlers.crafttweaker;

import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.api.recipes.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.util.StringUtils;
import com.blamejared.crafttweaker.impl.recipes.CTRecipeShaped;
import com.blamejared.crafttweaker.impl.recipes.helper.CraftingTableRecipeConflictChecker;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;

@IRecipeHandler.For(value=CTRecipeShaped.class)
public final class CTShapedRecipeHandler
implements IRecipeHandler<CTRecipeShaped> {
    @Override
    public String dumpToCommandString(IRecipeManager manager, CTRecipeShaped recipe) {
        return String.format("craftingTable.addShaped(%s, %s, %s%s);", StringUtils.quoteAndEscape(recipe.func_199560_c()), recipe.getCtOutput().getCommandString(), Arrays.stream(recipe.getCtIngredients()).map(row -> Arrays.stream(row).map(IIngredient::getCommandString).collect(Collectors.joining(", ", "[", "]"))).collect(Collectors.joining(", ", "[", "]")), recipe.getFunction() == null ? "" : ", (usualOut, inputs) => { ... }");
    }

    @Override
    public Optional<Function<ResourceLocation, CTRecipeShaped>> replaceIngredients(IRecipeManager manager, CTRecipeShaped recipe, List<IReplacementRule> rules) {
        return ReplacementHandlerHelper.replaceIngredientArray(this.flatten(recipe.getCtIngredients(), recipe.getRecipeWidth(), recipe.getRecipeHeight()), IIngredient.class, recipe, rules, newIngredients -> id -> new CTRecipeShaped(id.func_110623_a(), recipe.getCtOutput(), this.inflate((IIngredient[])newIngredients, recipe.getRecipeWidth(), recipe.getRecipeHeight()), recipe.getMirrorAxis(), recipe.getFunction()));
    }

    @Override
    public <U extends IRecipe<?>> boolean doesConflict(IRecipeManager manager, CTRecipeShaped firstRecipe, U secondRecipe) {
        return CraftingTableRecipeConflictChecker.checkConflicts(manager, firstRecipe, secondRecipe);
    }

    private IIngredient[] flatten(IIngredient[][] ingredients, int width, int height) {
        IIngredient[] flattened = new IIngredient[width * height];
        for (int i = 0; i < flattened.length; ++i) {
            flattened[i] = ingredients[i / width][i % width];
        }
        return flattened;
    }

    private IIngredient[][] inflate(IIngredient[] flattened, int width, int height) {
        IIngredient[][] inflated = new IIngredient[width][height];
        for (int i = 0; i < flattened.length; ++i) {
            inflated[i / width][i % width] = flattened[i];
        }
        return inflated;
    }
}

