/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.predicate;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.predicate.IVanillaWrappingPredicate;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.StateHolder;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.predicate.StatePropertiesPredicate")
@Document(value="vanilla/api/predicate/StatePropertiesPredicate")
public final class StatePropertiesPredicate
extends IVanillaWrappingPredicate.AnyDefaulting<net.minecraft.advancements.criterion.StatePropertiesPredicate> {
    private final Map<String, PropertyMatcher> propertyMatchers = new LinkedHashMap<String, PropertyMatcher>();

    public StatePropertiesPredicate() {
        super(net.minecraft.advancements.criterion.StatePropertiesPredicate.field_227178_a_);
    }

    @ZenCodeType.Method
    public StatePropertiesPredicate withExactProperty(String name, String value) {
        this.propertyMatchers.put(name, new ExactPropertyMatcher(value));
        return this;
    }

    @ZenCodeType.Method
    public StatePropertiesPredicate withExactProperty(String name, int value) {
        return this.withExactProperty(name, Integer.toString(value));
    }

    @ZenCodeType.Method
    public StatePropertiesPredicate withExactProperty(String name, boolean value) {
        return this.withExactProperty(name, Boolean.toString(value));
    }

    @ZenCodeType.Method
    public StatePropertiesPredicate withRangedProperty(String name, @ZenCodeType.Nullable String min, @ZenCodeType.Nullable String max) {
        this.propertyMatchers.put(name, new RangedPropertyMatcher(min, max));
        return this;
    }

    @ZenCodeType.Method
    public StatePropertiesPredicate withRangedProperty(String name, int min, int max) {
        return this.withRangedProperty(name, Integer.toString(min), Integer.toString(max));
    }

    @ZenCodeType.Method
    public StatePropertiesPredicate withUpperBoundedProperty(String name, int max) {
        return this.withRangedProperty(name, null, Integer.toString(max));
    }

    @ZenCodeType.Method
    public StatePropertiesPredicate withLowerBoundedProperty(String name, int min) {
        return this.withRangedProperty(name, Integer.toString(min), null);
    }

    public <S extends StateHolder<?, S>> boolean matchProperties(StateContainer<?, S> state, S blockState) {
        return this.propertyMatchers.entrySet().stream().allMatch(entry -> {
            Property targetProperty = state.func_185920_a((String)entry.getKey());
            return targetProperty != null && ((PropertyMatcher)entry.getValue()).getMatcherFunction().test(blockState, targetProperty);
        });
    }

    @Override
    public boolean isAny() {
        return this.propertyMatchers.isEmpty();
    }

    @Override
    public net.minecraft.advancements.criterion.StatePropertiesPredicate toVanilla() {
        List vanillaMatchers = this.propertyMatchers.entrySet().stream().map(this::toVanilla).collect(Collectors.toList());
        return new net.minecraft.advancements.criterion.StatePropertiesPredicate(vanillaMatchers);
    }

    private StatePropertiesPredicate.Matcher toVanilla(Map.Entry<String, PropertyMatcher> rawEntry) {
        return rawEntry.getValue().toVanilla().apply(rawEntry.getKey());
    }

    private static final class RangedPropertyMatcher
    implements PropertyMatcher {
        private final String min;
        private final String max;
        private final BiPredicate<StateHolder<?, ?>, Property<?>> matcher;

        private RangedPropertyMatcher(String min, String max) {
            this.min = min;
            this.max = max;
            this.matcher = (holder, property) -> RangedPropertyMatcher.match(holder, property, this.min, this.max);
        }

        @Override
        public BiPredicate<StateHolder<?, ?>, Property<?>> getMatcherFunction() {
            return this.matcher;
        }

        @Override
        public Function<String, StatePropertiesPredicate.Matcher> toVanilla() {
            return name -> new StatePropertiesPredicate.RangedMacher(name, this.min, this.max);
        }

        private static <T extends Comparable<T>> boolean match(StateHolder<?, ?> holder, Property<T> property, String min, String max) {
            Optional parsedMin;
            Comparable propertyValue = holder.func_177229_b(property);
            if (!(min == null || (parsedMin = property.func_185929_b(min)).isPresent() && propertyValue.compareTo(parsedMin.get()) >= 0)) {
                return false;
            }
            if (max != null) {
                Optional parsedMax = property.func_185929_b(max);
                return parsedMax.isPresent() && propertyValue.compareTo(parsedMax.get()) <= 0;
            }
            return true;
        }
    }

    private static final class ExactPropertyMatcher
    implements PropertyMatcher {
        private final String value;
        private final BiPredicate<StateHolder<?, ?>, Property<?>> matcher;

        private ExactPropertyMatcher(String value) {
            this.value = value;
            this.matcher = (holder, property) -> ExactPropertyMatcher.match(holder, property, this.value);
        }

        @Override
        public BiPredicate<StateHolder<?, ?>, Property<?>> getMatcherFunction() {
            return this.matcher;
        }

        @Override
        public Function<String, StatePropertiesPredicate.Matcher> toVanilla() {
            return name -> new StatePropertiesPredicate.ExactMatcher(name, this.value);
        }

        private static <T extends Comparable<T>> boolean match(StateHolder<?, ?> holder, Property<T> property, String value) {
            Comparable propertyValue = holder.func_177229_b(property);
            Optional targetValue = property.func_185929_b(value);
            return targetValue.isPresent() && propertyValue.compareTo(targetValue.get()) == 0;
        }
    }

    private static interface PropertyMatcher {
        public BiPredicate<StateHolder<?, ?>, Property<?>> getMatcherFunction();

        public Function<String, StatePropertiesPredicate.Matcher> toVanilla();
    }
}

