/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.predicate;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.predicate.BlockPredicate;
import com.blamejared.crafttweaker.impl.predicate.FloatRangePredicate;
import com.blamejared.crafttweaker.impl.predicate.FluidPredicate;
import com.blamejared.crafttweaker.impl.predicate.IVanillaWrappingPredicate;
import com.blamejared.crafttweaker.impl.predicate.LightPredicate;
import com.blamejared.crafttweaker.impl.predicate.TriState;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.function.Consumer;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.predicate.LocationPredicate")
@Document(value="vanilla/api/predicate/LocationPredicate")
public final class LocationPredicate
extends IVanillaWrappingPredicate.AnyDefaulting<net.minecraft.advancements.criterion.LocationPredicate> {
    private FloatRangePredicate x = FloatRangePredicate.unbounded();
    private FloatRangePredicate y = FloatRangePredicate.unbounded();
    private FloatRangePredicate z = FloatRangePredicate.unbounded();
    private ResourceLocation dimension;
    private String feature;
    private ResourceLocation biome;
    private TriState aboveCampfire = TriState.UNSET;
    private LightPredicate lightLevel = new LightPredicate();
    private BlockPredicate block = new BlockPredicate();
    private FluidPredicate fluid = new FluidPredicate();

    public LocationPredicate() {
        super(net.minecraft.advancements.criterion.LocationPredicate.field_193455_a);
    }

    @ZenCodeType.Method
    public LocationPredicate withMinimumXPosition(float min) {
        this.x = FloatRangePredicate.mergeLowerBound(this.x, min);
        return this;
    }

    @ZenCodeType.Method
    public LocationPredicate withMaximumXPosition(float max) {
        this.x = FloatRangePredicate.mergeUpperBound(this.x, max);
        return this;
    }

    @ZenCodeType.Method
    public LocationPredicate withRangedXPosition(float min, float max) {
        this.x = FloatRangePredicate.bounded(min, max);
        return this;
    }

    @ZenCodeType.Method
    public LocationPredicate withExactXPosition(float x) {
        return this.withRangedXPosition(x, x);
    }

    @ZenCodeType.Method
    public LocationPredicate withMinimumYPosition(float min) {
        this.y = FloatRangePredicate.mergeLowerBound(this.y, min);
        return this;
    }

    @ZenCodeType.Method
    public LocationPredicate withMaximumYPosition(float max) {
        this.y = FloatRangePredicate.mergeUpperBound(this.y, max);
        return this;
    }

    @ZenCodeType.Method
    public LocationPredicate withRangedYPosition(float min, float max) {
        this.y = FloatRangePredicate.bounded(min, max);
        return this;
    }

    @ZenCodeType.Method
    public LocationPredicate withExactYPosition(int y) {
        return this.withRangedYPosition(y, y);
    }

    @ZenCodeType.Method
    public LocationPredicate withMinimumZPosition(float min) {
        this.z = FloatRangePredicate.mergeLowerBound(this.z, min);
        return this;
    }

    @ZenCodeType.Method
    public LocationPredicate withMaximumZPosition(float max) {
        this.z = FloatRangePredicate.mergeUpperBound(this.z, max);
        return this;
    }

    @ZenCodeType.Method
    public LocationPredicate withRangedZPosition(float min, float max) {
        this.z = FloatRangePredicate.bounded(min, max);
        return this;
    }

    @ZenCodeType.Method
    public LocationPredicate withExactZPosition(int z) {
        return this.withRangedZPosition(z, z);
    }

    @ZenCodeType.Method
    public LocationPredicate withDimension(ResourceLocation dimension) {
        this.dimension = dimension;
        return this;
    }

    @ZenCodeType.Method
    public LocationPredicate withFeatureName(String feature) {
        this.feature = feature;
        return this;
    }

    @ZenCodeType.Method
    public LocationPredicate withBiomeName(ResourceLocation biome) {
        this.biome = biome;
        return this;
    }

    @ZenCodeType.Method
    public LocationPredicate withCampfireBelow() {
        this.aboveCampfire = TriState.TRUE;
        return this;
    }

    @ZenCodeType.Method
    public LocationPredicate withoutCampfireBelow() {
        this.aboveCampfire = TriState.FALSE;
        return this;
    }

    @ZenCodeType.Method
    public LocationPredicate withLightPredicate(Consumer<LightPredicate> builder) {
        LightPredicate predicate = new LightPredicate();
        builder.accept(predicate);
        this.lightLevel = predicate;
        return this;
    }

    @ZenCodeType.Method
    public LocationPredicate withBlockPredicate(Consumer<BlockPredicate> builder) {
        BlockPredicate predicate = new BlockPredicate();
        builder.accept(predicate);
        this.block = predicate;
        return this;
    }

    @ZenCodeType.Method
    public LocationPredicate withFluidPredicate(Consumer<FluidPredicate> builder) {
        FluidPredicate predicate = new FluidPredicate();
        builder.accept(predicate);
        this.fluid = predicate;
        return this;
    }

    @Override
    public boolean isAny() {
        return this.x.isAny() && this.y.isAny() && this.z.isAny() && this.dimension == null && this.feature == null && this.biome == null && this.aboveCampfire.isUnset() && this.lightLevel.isAny() && this.block.isAny() && this.fluid.isAny();
    }

    @Override
    public net.minecraft.advancements.criterion.LocationPredicate toVanilla() {
        return new net.minecraft.advancements.criterion.LocationPredicate((MinMaxBounds.FloatBound)this.x.toVanillaPredicate(), (MinMaxBounds.FloatBound)this.y.toVanillaPredicate(), (MinMaxBounds.FloatBound)this.z.toVanillaPredicate(), this.toVanilla(ForgeRegistries.BIOMES, this.biome), this.feature == null ? null : (Structure)Structure.field_236365_a_.get((Object)this.feature), this.toVanilla(Registry.field_239699_ae_, this.dimension), this.aboveCampfire.toBoolean(), (net.minecraft.advancements.criterion.LightPredicate)this.lightLevel.toVanillaPredicate(), (net.minecraft.advancements.criterion.BlockPredicate)this.block.toVanillaPredicate(), (net.minecraft.advancements.criterion.FluidPredicate)this.fluid.toVanillaPredicate());
    }

    private <T> RegistryKey<T> toVanilla(RegistryKey<? extends Registry<T>> registry, ResourceLocation name) {
        if (name == null) {
            return null;
        }
        return RegistryKey.func_240903_a_(registry, (ResourceLocation)name);
    }

    private <T extends IForgeRegistryEntry<T>> RegistryKey<T> toVanilla(IForgeRegistry<T> dumbForge, ResourceLocation name) {
        if (!(dumbForge instanceof ForgeRegistry)) {
            throw new IllegalStateException("Not a forge registry: '" + dumbForge.getRegistryName() + "' (was " + dumbForge + ")");
        }
        return this.toVanilla(((ForgeRegistry)dumbForge).getRegistryKey(), name);
    }
}

