/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.loot.conditions.vanilla;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.loot.conditions.ILootCondition;
import com.blamejared.crafttweaker.impl.loot.conditions.ILootConditionTypeBuilder;
import com.blamejared.crafttweaker.impl_native.loot.ExpandLootContext;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Arrays;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.loot.conditions.vanilla.TableBonus")
@Document(value="vanilla/api/loot/conditions/vanilla/TableBonus")
public final class TableBonusLootConditionTypeBuilder
implements ILootConditionTypeBuilder {
    private Enchantment enchantment;
    private float[] chances;

    TableBonusLootConditionTypeBuilder() {
    }

    @ZenCodeType.Method
    public TableBonusLootConditionTypeBuilder withEnchantment(Enchantment enchantment) {
        this.enchantment = enchantment;
        return this;
    }

    @ZenCodeType.Method
    public TableBonusLootConditionTypeBuilder withChances(float[] chances) {
        this.chances = chances;
        return this;
    }

    @Override
    public ILootCondition finish() {
        if (this.enchantment == null) {
            throw new IllegalStateException("Enchantment not set");
        }
        if (this.chances.length == 0) {
            throw new IllegalStateException("Unable to have an empty set of chances for a table bonus");
        }
        boolean foundHigherThanZero = false;
        boolean foundSmallerThanOne = false;
        for (float chance : this.chances) {
            if (chance < 1.0f) {
                foundSmallerThanOne = true;
            }
            if (!(chance > 0.0f)) continue;
            foundHigherThanZero = true;
        }
        if (!foundHigherThanZero) {
            CraftTweakerAPI.logWarning("The chance values in a 'TableBonus' condition are all less than or equal to 0.0: this will never match! Conditions: %s", Arrays.toString(this.chances));
        }
        if (!foundSmallerThanOne) {
            CraftTweakerAPI.logWarning("The chance values in a 'TableBonus' condition are all more than or equal to 1.0: this will always match! Conditions: %s", Arrays.toString(this.chances));
        }
        return context -> {
            ItemStack stack = ExpandLootContext.getTool(context).getInternal();
            int chancesIndex = stack.func_190926_b() ? 0 : EnchantmentHelper.func_77506_a((Enchantment)this.enchantment, (ItemStack)stack);
            float chance = this.chances[Math.min(chancesIndex, this.chances.length - 1)];
            return context.func_216032_b().nextFloat() < chance;
        };
    }
}

