/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.loot.conditions.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.loot.conditions.ILootCondition;
import com.blamejared.crafttweaker.impl.loot.conditions.CTLootConditionBuilder;
import com.blamejared.crafttweaker.impl.loot.conditions.ILootConditionTypeBuilder;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.loot.conditions.crafttweaker.And")
@Document(value="vanilla/api/loot/conditions/crafttweaker/And")
public final class AndLootConditionTypeBuilder
implements ILootConditionTypeBuilder {
    private final CTLootConditionBuilder parent;
    private final List<ILootCondition> subConditions;

    AndLootConditionTypeBuilder(CTLootConditionBuilder parent) {
        this.parent = parent;
        this.subConditions = new ArrayList<ILootCondition>();
    }

    @ZenCodeType.Method
    public <T extends ILootConditionTypeBuilder> AndLootConditionTypeBuilder add(Class<T> reifiedType, Consumer<T> lender) {
        ILootCondition subCondition = this.parent.make(reifiedType, "And", lender);
        if (subCondition != null) {
            this.subConditions.add(subCondition);
        }
        return this;
    }

    @Override
    public ILootCondition finish() {
        if (this.subConditions.isEmpty()) {
            CraftTweakerAPI.logWarning("An 'And' loot condition has no conditions: this will always match!", new Object[0]);
        } else if (this.subConditions.size() == 1) {
            CraftTweakerAPI.logWarning("An 'And' loot condition has only one condition: this is equivalent to the condition itself", new Object[0]);
        }
        return context -> this.subConditions.stream().allMatch(it -> it.test(context));
    }
}

