/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.item.conditions;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.conditions.IIngredientCondition;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.blamejared.crafttweaker.impl.item.conditions.IngredientConditioned;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.item.crafting.Ingredient;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.item.MCIngredientConditioned")
@Document(value="vanilla/api/items/MCIngredientConditioned")
public class MCIngredientConditioned<T extends IIngredient>
implements IIngredient {
    private final T base;
    private final IIngredientCondition<T> condition;

    public MCIngredientConditioned(T base, IIngredientCondition<T> condition) {
        this.base = base;
        this.condition = condition;
    }

    @Override
    public Ingredient asVanillaIngredient() {
        return new IngredientConditioned(this);
    }

    @ZenCodeType.Getter(value="condition")
    public IIngredientCondition<T> getCondition() {
        return this.condition;
    }

    @Override
    public String getCommandString() {
        return this.condition.getCommandString(this.base);
    }

    @ZenCodeType.Getter(value="baseIngredient")
    public T getBaseIngredient() {
        return this.base;
    }

    @Override
    @ZenCodeType.Method
    public boolean matches(IItemStack stack, boolean ignoreDamage) {
        return this.base.matches(stack, this.condition.ignoresDamage()) && this.condition.matches(stack);
    }

    @Override
    @ZenCodeType.Getter(value="items")
    public IItemStack[] getItems() {
        return this.base.getItems();
    }

    @Override
    @ZenCodeType.Caster(implicit=true)
    public MapData asMapData() {
        return this.base.asMapData();
    }

    @Override
    @ZenCodeType.Caster(implicit=true)
    public IData asIData() {
        return this.base.asIData();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MCIngredientConditioned that = (MCIngredientConditioned)o;
        if (!this.base.equals(that.base)) {
            return false;
        }
        return this.condition.equals(that.condition);
    }

    public int hashCode() {
        int result = this.base.hashCode();
        result = 31 * result + this.condition.hashCode();
        return result;
    }
}

