/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.helper;

import com.blamejared.crafttweaker.api.data.NBTConverter;
import com.blamejared.crafttweaker.impl.data.MapData;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public final class ItemStackHelper {
    public static String getCommandString(ItemStack stack) {
        return ItemStackHelper.getCommandString(stack, false);
    }

    public static String getCommandString(ItemStack stack, boolean mutable) {
        StringBuilder sb = new StringBuilder("<item:");
        sb.append(stack.func_77973_b().getRegistryName());
        sb.append('>');
        if (stack.func_77978_p() != null) {
            MapData data = (MapData)NBTConverter.convert((INBT)stack.func_77978_p()).copyInternal();
            if (stack.func_77973_b().func_77645_m()) {
                data.remove("Damage");
            }
            if (!data.isEmpty()) {
                sb.append(".withTag(");
                sb.append(data.asString());
                sb.append(')');
            }
        }
        if (stack.func_77952_i() > 0) {
            sb.append(".withDamage(").append(stack.func_77952_i()).append(')');
        }
        if (!stack.func_190926_b() && stack.func_190916_E() != 1) {
            sb.append(" * ").append(stack.func_190916_E());
        }
        if (mutable) {
            sb.append(".mutable()");
        }
        return sb.toString();
    }

    public static boolean areStacksTheSame(ItemStack first, ItemStack second) {
        if (first.func_190926_b() != second.func_190926_b()) {
            return false;
        }
        if (first.func_77973_b() != second.func_77973_b()) {
            return false;
        }
        if (first.func_190916_E() > second.func_190916_E()) {
            return false;
        }
        if (first.func_77952_i() != second.func_77952_i()) {
            return false;
        }
        CompoundNBT firstTag = first.func_77978_p();
        CompoundNBT secondTag = second.func_77978_p();
        if (firstTag == null) {
            return true;
        }
        if (secondTag == null) {
            return false;
        }
        return firstTag.equals((Object)secondTag);
    }
}

