/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.fluid;

import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.NBTConverter;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.blamejared.crafttweaker.impl.fluid.MCFluidStackMutable;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.INBT;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

public class MCFluidStack
implements IFluidStack {
    public static Supplier<MCFluidStack> EMPTY = () -> new MCFluidStack(FluidStack.EMPTY);
    private final FluidStack stack;

    public MCFluidStack(FluidStack fluidStack) {
        this.stack = fluidStack;
    }

    @Override
    public String getCommandString() {
        MapData data;
        Fluid fluid = this.getInternal().getFluid();
        StringBuilder builder = new StringBuilder().append("<fluid:").append(fluid.getRegistryName()).append(">");
        if (this.getInternal().hasTag() && !(data = (MapData)NBTConverter.convert((INBT)this.getInternal().getTag()).copyInternal()).isEmpty()) {
            builder.append(".withTag(");
            builder.append(data.asString());
            builder.append(")");
        }
        if (!this.isEmpty() && this.getInternal().getAmount() != 1) {
            builder.append(" * ").append(this.getInternal().getAmount());
        }
        return builder.toString();
    }

    @Override
    public IFluidStack setAmount(int amount) {
        FluidStack copy = this.getInternal().copy();
        copy.setAmount(amount);
        return new MCFluidStack(copy);
    }

    @Override
    public IFluidStack multiply(int amount) {
        return this.setAmount(amount);
    }

    @Override
    public IFluidStack mutable() {
        return new MCFluidStackMutable(this.getInternal());
    }

    @Override
    public IFluidStack asImmutable() {
        return this;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public IFluidStack copy() {
        return new MCFluidStack(this.getInternal().copy());
    }

    @Override
    public Fluid getFluid() {
        return this.getInternal().getFluid();
    }

    @Override
    public IFluidStack withTag(IData tag) {
        FluidStack copy = this.getInternal().copy();
        if (!(tag instanceof MapData)) {
            tag = new MapData(tag.asMap());
        }
        copy.setTag(((MapData)tag).getInternal());
        return new MCFluidStack(copy);
    }

    @Override
    public IData getTag() {
        return NBTConverter.convert((INBT)this.getInternal().getTag());
    }

    @Override
    public FluidStack getInternal() {
        return this.stack;
    }

    @Override
    public FluidStack getImmutableInternal() {
        return this.stack;
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluidStack thatStack = ((MCFluidStack)o).getInternal();
        FluidStack thisStack = this.getInternal();
        if (thisStack.isEmpty()) {
            return thatStack.isEmpty();
        }
        if (thisStack.getAmount() != thatStack.getAmount()) {
            return false;
        }
        if (!Objects.equals(thisStack.getFluid(), thatStack.getFluid())) {
            return false;
        }
        return Objects.equals(thisStack.getTag(), thatStack.getTag());
    }

    public int hashCode() {
        return Objects.hash(this.getInternal().getAmount(), this.getInternal().getFluid(), this.getInternal().getTag());
    }
}

