/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.tags;

import com.blamejared.crafttweaker.api.actions.IRuntimeAction;
import com.blamejared.crafttweaker.api.logger.ILogger;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class ActionTag<T extends ForgeRegistryEntry<?>>
implements IRuntimeAction {
    protected final ITag<T> tag;
    protected final MCTag<?> mcTag;

    public ActionTag(ITag<T> tag, MCTag<?> mcTag) {
        this.tag = tag;
        this.mcTag = mcTag;
    }

    public ITag<T> getTag() {
        return this.tag;
    }

    public ResourceLocation getId() {
        return this.mcTag.getIdInternal();
    }

    public String getType() {
        return this.mcTag.getManager().getTagFolder();
    }

    @Override
    public boolean validate(ILogger logger) {
        if (this.getTag() == null) {
            logger.throwingErr("Tag " + this.mcTag + " does not exist!", new NullPointerException("Internal tag was null!"));
            return false;
        }
        return true;
    }
}

