/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.brewing;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.actions.brewing.ActionBrewingBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.registries.IRegistryDelegate;

public class ActionRemoveBrewingRecipeByReagent
extends ActionBrewingBase {
    private final IItemStack reagent;
    private final List<PotionBrewing.MixPredicate<Potion>> removed = new ArrayList<PotionBrewing.MixPredicate<Potion>>();
    private final List<IBrewingRecipe> removedRecipes = new ArrayList<IBrewingRecipe>();

    public ActionRemoveBrewingRecipeByReagent(List<IBrewingRecipe> recipes, IItemStack reagent) {
        super(recipes);
        this.reagent = reagent;
    }

    @Override
    public void apply() {
        Iterator vanillaIterator = PotionBrewing.field_185213_a.iterator();
        while (vanillaIterator.hasNext()) {
            PotionBrewing.MixPredicate mix = (PotionBrewing.MixPredicate)vanillaIterator.next();
            Ingredient reagentInput = this.getItemReagent((PotionBrewing.MixPredicate<Potion>)mix);
            if (reagentInput == null) {
                throw new RuntimeException("Error getting potion from mix: " + mix + "! Please make an issue on the issue tracker!");
            }
            if (!reagentInput.test(this.reagent.getInternal())) continue;
            this.removed.add((PotionBrewing.MixPredicate<Potion>)mix);
            vanillaIterator.remove();
        }
        Iterator registryIterator = this.recipes.iterator();
        while (registryIterator.hasNext()) {
            IBrewingRecipe next = (IBrewingRecipe)registryIterator.next();
            if (!next.isIngredient(this.reagent.getInternal())) continue;
            this.removedRecipes.add(next);
            registryIterator.remove();
        }
    }

    @Override
    public void undo() {
        for (PotionBrewing.MixPredicate<Potion> potion : this.removed) {
            IRegistryDelegate potionInput = potion.field_185198_a;
            Ingredient itemReagent = this.getItemReagent(potion);
            IRegistryDelegate potionOutput = potion.field_185200_c;
            if (potionInput == null || itemReagent == null || potionOutput == null) {
                CraftTweakerAPI.logError("Error getting mix entries! potionInput: %s, itemReagent: %s, potionOutput: %s", potionInput, itemReagent, potionOutput);
                continue;
            }
            PotionBrewing.func_193357_a((Potion)((Potion)potionInput.get()), (Item)itemReagent.func_193365_a()[0].func_77973_b(), (Potion)((Potion)potionOutput.get()));
        }
        this.removedRecipes.forEach(BrewingRecipeRegistry::addRecipe);
    }

    @Override
    public String describe() {
        return "Removing Brewing recipes that have a reagent of: " + this.reagent;
    }

    @Override
    public String describeUndo() {
        return "Undoing removal of Brewing recipes that have a reagent of: " + this.reagent;
    }
}

