/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipes;

import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public final class ReplacementHandlerHelper {
    private ReplacementHandlerHelper() {
    }

    public static <T extends IRecipe<?>, U> Optional<Function<ResourceLocation, T>> replaceNonNullIngredientList(NonNullList<U> originalIngredients, Class<U> ingredientClass, T recipe, List<IReplacementRule> rules, Function<NonNullList<U>, Function<ResourceLocation, T>> factory) {
        return ReplacementHandlerHelper.replaceIngredientList(originalIngredients, ingredientClass, recipe, rules, list -> (Function)factory.apply((NonNullList)Util.func_200696_a((Object)NonNullList.func_191196_a(), it -> it.addAll((Collection)list))));
    }

    public static <T extends IRecipe<?>, U> Optional<Function<ResourceLocation, T>> replaceIngredientList(List<U> originalIngredients, Class<U> ingredientClass, T recipe, List<IReplacementRule> rules, Function<List<U>, Function<ResourceLocation, T>> factory) {
        ReplacementMap replacements = IntStream.range(0, originalIngredients.size()).mapToObj(i -> Pair.of((Object)i, IRecipeHandler.attemptReplacing(originalIngredients.get(i), ingredientClass, recipe, rules))).filter(it -> ((Optional)it.getSecond()).isPresent()).collect(ReplacementMap::new, ReplacementMap::put, ReplacementMap::merge);
        if (replacements.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<U> newIngredients = new ArrayList<U>(originalIngredients);
        replacements.fill(newIngredients::set);
        return Optional.of(factory.apply(newIngredients));
    }

    public static <T extends IRecipe<?>, U> Optional<Function<ResourceLocation, T>> replaceIngredientArray(U[] originalIngredients, Class<U> ingredientClass, T recipe, List<IReplacementRule> rules, Function<U[], Function<ResourceLocation, T>> factory) {
        ReplacementMap replacements = IntStream.range(0, originalIngredients.length).mapToObj(i -> Pair.of((Object)i, IRecipeHandler.attemptReplacing(originalIngredients[i], ingredientClass, recipe, rules))).filter(it -> ((Optional)it.getSecond()).isPresent()).collect(ReplacementMap::new, ReplacementMap::put, ReplacementMap::merge);
        if (replacements.isEmpty()) {
            return Optional.empty();
        }
        Object[] newIngredients = Arrays.copyOf(originalIngredients, originalIngredients.length);
        replacements.fill((i, ing) -> {
            newIngredients[i] = ing;
        });
        return Optional.of(factory.apply(newIngredients));
    }

    private static final class ReplacementMap<T> {
        private final Int2ObjectMap<T> delegate = new Int2ObjectRBTreeMap();

        ReplacementMap() {
            this.delegate.defaultReturnValue(null);
        }

        void fill(ReplacementConsumer<T> consumer) {
            this.delegate.int2ObjectEntrySet().forEach(it -> consumer.accept(it.getIntKey(), it.getValue()));
        }

        void put(int index, T ingredient) {
            this.delegate.put(index, ingredient);
        }

        void put(Pair<Integer, Optional<T>> pair) {
            this.put((Integer)pair.getFirst(), ((Optional)pair.getSecond()).get());
        }

        void merge(ReplacementMap<T> other) {
            this.delegate.putAll(other.delegate);
        }

        boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        private static interface ReplacementConsumer<T> {
            public void accept(int var1, T var2);
        }
    }
}

