/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.actions;

import com.blamejared.crafttweaker.CraftTweaker;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.logger.ILogger;
import com.blamejared.crafttweaker.api.util.ClientHelper;
import com.blamejared.crafttweaker.api.util.ServerHelper;
import com.blamejared.crafttweaker.api.zencode.impl.util.PositionUtil;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import org.openzen.zencode.shared.CodePosition;

public interface IAction {
    public void apply();

    public String describe();

    default public boolean validate(ILogger logger) {
        return true;
    }

    default public boolean shouldApplyOn(LogicalSide side) {
        return CraftTweaker.serverOverride || side.isServer();
    }

    @Nonnull
    default public CodePosition getDeclaredScriptPosition() {
        return PositionUtil.getZCScriptPositionFromStackTrace();
    }

    default public boolean shouldApplySingletons() {
        return (Boolean)DistExecutor.safeRunForDist(() -> ClientHelper::shouldApplyServerActionOnClient, () -> ServerHelper::alwaysTrue);
    }

    default public boolean assertLoader(String loader) {
        String currentLoader = CraftTweakerAPI.getCurrentRun().getLoaderActions().getLoaderName();
        if (currentLoader.equals(loader)) {
            return true;
        }
        CraftTweakerAPI.logWarning("Action '%s' (%s) can only be invoked on loader '%s'. You tried to run it on loader '%s'.", this.getClass().getName(), this.getDeclaredScriptPosition().toString(), loader, currentLoader);
        return false;
    }
}

