/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.config.value;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mcp.mobius.waila.gui.config.value.OptionsEntryValue;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import snownee.jade.Jade;

public class OptionsEntryValueSlider
extends OptionsEntryValue<Float> {
    public static final Predicate<String> ANY = s -> true;
    public static final Predicate<String> INTEGER = s -> s.matches("^[0-9]*$");
    public static final Predicate<String> FLOAT = s -> s.matches("[-+]?([0-9]*\\.[0-9]+|[0-9]+)") || s.endsWith(".") || s.isEmpty();
    private final Slider slider;
    private float min;
    private float max;

    public OptionsEntryValueSlider(String optionName, float value, Consumer<Float> save, float min, float max) {
        super(optionName, save);
        this.value = Float.valueOf(value);
        this.min = min;
        this.max = max;
        this.slider = new Slider(this, 0, 0, 100, 20, this.getTitle());
    }

    public OptionsEntryValueSlider(String optionName, float value, Consumer<Float> save) {
        this(optionName, value, save, 0.0f, 1.0f);
    }

    @Override
    protected void drawValue(MatrixStack matrixStack, int entryWidth, int entryHeight, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
        this.slider.field_230690_l_ = x + 135;
        this.slider.field_230691_m_ = y + entryHeight / 6;
        this.slider.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public IGuiEventListener getListener() {
        return this.slider;
    }

    public static class Slider
    extends AbstractSlider {
        private final OptionsEntryValueSlider value;

        public Slider(OptionsEntryValueSlider value, int x, int y, int width, int height, ITextComponent message) {
            super(x, y, width, height, message, Slider.fromScaled(((Float)value.value).floatValue(), value.min, value.max));
            this.value = value;
            this.func_230972_a_();
        }

        public float toScaled() {
            return this.value.min + (this.value.max - this.value.min) * (float)this.field_230683_b_;
        }

        public static double fromScaled(float f, float min, float max) {
            return MathHelper.func_76131_a((float)((f - min) / (max - min)), (float)0.0f, (float)1.0f);
        }

        protected void func_230979_b_() {
            this.value.value = Float.valueOf(this.toScaled());
            this.value.save();
        }

        protected void func_230972_a_() {
            this.func_238482_a_((ITextComponent)new StringTextComponent(Jade.dfCommas.format(this.toScaled())));
        }
    }
}

