/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.additions.common.entity.EntityBalloon;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ItemBalloon
extends Item {
    private final EnumColor color;

    public ItemBalloon(EnumColor color) {
        super(ItemDeferredRegister.getMekBaseProperties());
        this.color = color;
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)new DispenserBehavior(this.color));
    }

    public EnumColor getColor() {
        return this.color;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, @Nonnull PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            boolean rightHand = player.func_184591_cq() == HandSide.RIGHT == (hand == Hand.MAIN_HAND);
            Pos3D pos = new Pos3D(rightHand ? -0.4 : 0.4, 0.0, 0.3).yRot(player.field_70761_aq).translate((Vector3d)new Pos3D((Entity)player));
            EntityBalloon balloon = EntityBalloon.create(world, pos.field_72450_a - 0.5, pos.field_72448_b - 1.25, pos.field_72449_c - 0.5, this.color);
            if (balloon == null) {
                return new ActionResult(ActionResultType.FAIL, (Object)stack);
            }
            world.func_217376_c((Entity)balloon);
        }
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBalloon) {
            return TextComponentUtil.build((Object[])new Object[]{((ItemBalloon)item).getColor(), super.func_200295_i(stack)});
        }
        return super.func_200295_i(stack);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        ItemStack stack = context.func_195996_i();
        if (player.func_225608_bj_()) {
            BlockPos pos = context.func_195995_a();
            AxisAlignedBB bound = new AxisAlignedBB(pos, pos.func_177982_a(1, 3, 1));
            List balloonsNear = player.field_70170_p.func_217357_a(EntityBalloon.class, bound);
            if (!balloonsNear.isEmpty()) {
                return ActionResultType.FAIL;
            }
            World world = context.func_195991_k();
            if (WorldUtils.isValidReplaceableBlock((IBlockReader)world, (BlockPos)pos)) {
                pos = pos.func_177977_b();
            }
            if (!Block.func_220055_a((IWorldReader)world, (BlockPos)pos, (Direction)Direction.UP)) {
                return ActionResultType.FAIL;
            }
            if (WorldUtils.isValidReplaceableBlock((IBlockReader)world, (BlockPos)pos.func_177984_a()) && WorldUtils.isValidReplaceableBlock((IBlockReader)world, (BlockPos)pos.func_177981_b(2))) {
                world.func_217377_a(pos.func_177984_a(), false);
                world.func_217377_a(pos.func_177981_b(2), false);
                if (!world.field_72995_K) {
                    EntityBalloon balloon = EntityBalloon.create(world, pos, this.color);
                    if (balloon == null) {
                        return ActionResultType.FAIL;
                    }
                    world.func_217376_c((Entity)balloon);
                    stack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public ActionResultType func_111207_a(@Nonnull ItemStack stack, PlayerEntity player, @Nonnull LivingEntity entity, @Nonnull Hand hand) {
        if (player.func_225608_bj_()) {
            if (!player.field_70170_p.field_72995_K) {
                AxisAlignedBB bound = new AxisAlignedBB(entity.func_226277_ct_() - 0.2, entity.func_226278_cu_() - 0.5, entity.func_226281_cx_() - 0.2, entity.func_226277_ct_() + 0.2, entity.func_226278_cu_() + (double)entity.func_213305_a((Pose)entity.func_213283_Z()).field_220316_b + 4.0, entity.func_226281_cx_() + 0.2);
                List balloonsNear = player.field_70170_p.func_217357_a(EntityBalloon.class, bound);
                for (EntityBalloon balloon : balloonsNear) {
                    if (balloon.latchedEntity != entity) continue;
                    return ActionResultType.SUCCESS;
                }
                EntityBalloon balloon = EntityBalloon.create(entity, this.color);
                if (balloon == null) {
                    return ActionResultType.FAIL;
                }
                player.field_70170_p.func_217376_c((Entity)balloon);
                stack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private static class DispenserBehavior
    extends DefaultDispenseItemBehavior {
        private final EnumColor color;

        public DispenserBehavior(EnumColor color) {
            this.color = color;
        }

        @Nonnull
        public ItemStack func_82487_b(IBlockSource source, @Nonnull ItemStack stack) {
            Direction side = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
            BlockPos sourcePos = source.func_180699_d();
            BlockPos offsetPos = sourcePos.func_177972_a(side);
            List entities = source.func_197524_h().func_217357_a(LivingEntity.class, new AxisAlignedBB(offsetPos, offsetPos.func_177982_a(1, 1, 1)));
            boolean latched = false;
            for (LivingEntity entity : entities) {
                AxisAlignedBB bound = new AxisAlignedBB(entity.func_226277_ct_() - 0.2, entity.func_226278_cu_() - 0.5, entity.func_226281_cx_() - 0.2, entity.func_226277_ct_() + 0.2, entity.func_226278_cu_() + (double)entity.func_213305_a((Pose)entity.func_213283_Z()).field_220316_b + 4.0, entity.func_226281_cx_() + 0.2);
                List balloonsNear = source.func_197524_h().func_217357_a(EntityBalloon.class, bound);
                boolean hasBalloon = false;
                for (EntityBalloon balloon : balloonsNear) {
                    if (balloon.latchedEntity != entity) continue;
                    hasBalloon = true;
                    break;
                }
                if (hasBalloon) continue;
                EntityBalloon balloon = EntityBalloon.create(entity, this.color);
                if (balloon != null) {
                    source.func_197524_h().func_217376_c((Entity)balloon);
                }
                latched = true;
            }
            if (!latched) {
                EntityBalloon balloon;
                Vector3d pos = Vector3d.func_237491_b_((Vector3i)sourcePos).func_72441_c(0.0, -0.5, 0.0);
                switch (side) {
                    case DOWN: {
                        pos = pos.func_72441_c(0.0, -3.5, 0.0);
                        break;
                    }
                    case NORTH: {
                        pos = pos.func_72441_c(0.0, -1.0, -0.5);
                        break;
                    }
                    case SOUTH: {
                        pos = pos.func_72441_c(0.0, -1.0, 0.5);
                        break;
                    }
                    case WEST: {
                        pos = pos.func_72441_c(-0.5, -1.0, 0.0);
                        break;
                    }
                    case EAST: {
                        pos = pos.func_72441_c(0.5, -1.0, 0.0);
                        break;
                    }
                }
                if (!source.func_197524_h().field_72995_K && (balloon = EntityBalloon.create((World)source.func_197524_h(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, this.color)) != null) {
                    source.func_197524_h().func_217376_c((Entity)balloon);
                }
            }
            stack.func_190918_g(1);
            return stack;
        }
    }
}

