/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.common.entity.movement;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.MobEntity;
import net.minecraft.pathfinding.FlaggedPathPoint;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathHeap;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Region;

public class CustomPathFinder
extends PathFinder {
    private final PathHeap path = new PathHeap();
    private final PathPoint[] pathOptions = new PathPoint[32];
    private final NodeProcessor nodeProcessor;
    private int maxExpansions = 200;
    public static final Heuristic DEFAULT_HEURISTIC = (start, end, isTargetHeuristic) -> start.func_224757_c(end);
    private Heuristic heuristic = DEFAULT_HEURISTIC;

    public CustomPathFinder(NodeProcessor processor, int maxExpansions) {
        super(processor, maxExpansions);
        this.nodeProcessor = processor;
        this.maxExpansions = maxExpansions;
    }

    public NodeProcessor getNodeProcessor() {
        return this.nodeProcessor;
    }

    public CustomPathFinder setMaxExpansions(int expansions) {
        this.maxExpansions = expansions;
        return this;
    }

    public CustomPathFinder setHeuristic(Heuristic heuristic) {
        this.heuristic = heuristic;
        return this;
    }

    @Nullable
    public Path func_227478_a_(Region region, MobEntity entity, Set<BlockPos> checkpoints, float maxDistance, int checkpointRange, float maxExpansionsMultiplier) {
        this.path.func_75848_a();
        this.nodeProcessor.func_225578_a_(region, entity);
        PathPoint pathpoint = this.nodeProcessor.func_186318_b();
        Map<FlaggedPathPoint, BlockPos> checkpointsMap = checkpoints.stream().collect(Collectors.toMap(pos -> this.nodeProcessor.func_224768_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), Function.identity()));
        Path path = this.findPath(pathpoint, checkpointsMap, maxDistance, checkpointRange, maxExpansionsMultiplier);
        this.nodeProcessor.func_176163_a();
        return path;
    }

    @Nullable
    private Path findPath(PathPoint start, Map<FlaggedPathPoint, BlockPos> checkpointsMap, float maxDistance, int checkpointRange, float maxExpansionsMultiplier) {
        Set<FlaggedPathPoint> checkpoints = checkpointsMap.keySet();
        start.field_75836_e = 0.0f;
        start.field_75834_g = start.field_75833_f = this.computeHeuristic(start, checkpoints);
        this.path.func_75848_a();
        this.path.func_75849_a(start);
        HashSet reachedCheckpoints = Sets.newHashSetWithExpectedSize((int)checkpoints.size());
        int expansions = 0;
        int maxExpansions = (int)((float)this.maxExpansions * maxExpansionsMultiplier);
        while (!this.path.func_75845_e() && ++expansions < maxExpansions) {
            PathPoint openPathPoint = this.path.func_75844_c();
            openPathPoint.field_75842_i = true;
            for (FlaggedPathPoint checkpoint2 : checkpoints) {
                if (!(openPathPoint.func_224757_c((PathPoint)checkpoint2) <= (float)checkpointRange)) continue;
                checkpoint2.func_224764_e();
                reachedCheckpoints.add(checkpoint2);
            }
            if (!reachedCheckpoints.isEmpty()) break;
            if (!(openPathPoint.func_75829_a(start) < maxDistance)) continue;
            int numOptions = this.nodeProcessor.func_222859_a(this.pathOptions, openPathPoint);
            for (int i = 0; i < numOptions; ++i) {
                PathPoint successorPathPoint = this.pathOptions[i];
                float costHeuristic = openPathPoint.func_75829_a(successorPathPoint);
                successorPathPoint.field_222861_j = openPathPoint.field_222861_j + costHeuristic;
                float totalSuccessorPathCost = openPathPoint.field_75836_e + costHeuristic + successorPathPoint.field_186286_l;
                if (!(successorPathPoint.field_222861_j < maxDistance) || successorPathPoint.func_75831_a() && !(totalSuccessorPathCost < successorPathPoint.field_75836_e)) continue;
                successorPathPoint.field_75841_h = openPathPoint;
                successorPathPoint.field_75836_e = totalSuccessorPathCost;
                successorPathPoint.field_75833_f = this.computeHeuristic(successorPathPoint, checkpoints) * 1.0f;
                if (successorPathPoint.func_75831_a()) {
                    this.path.func_75850_a(successorPathPoint, successorPathPoint.field_75836_e + successorPathPoint.field_75833_f);
                    continue;
                }
                successorPathPoint.field_75834_g = successorPathPoint.field_75836_e + successorPathPoint.field_75833_f;
                this.path.func_75849_a(successorPathPoint);
            }
        }
        Optional<Path> path = !reachedCheckpoints.isEmpty() ? reachedCheckpoints.stream().map(checkpoint -> this.createPath(checkpoint.func_224763_d(), (BlockPos)checkpointsMap.get(checkpoint), true)).min(Comparator.comparingInt(Path::func_75874_d)) : checkpoints.stream().map(checkpoint -> this.createPath(checkpoint.func_224763_d(), (BlockPos)checkpointsMap.get(checkpoint), false)).min(Comparator.comparingDouble(Path::func_224769_l).thenComparingInt(Path::func_75874_d));
        return !path.isPresent() ? null : path.get();
    }

    private float computeHeuristic(PathPoint pathPoint, Set<FlaggedPathPoint> checkpoints) {
        float minDst = Float.MAX_VALUE;
        for (FlaggedPathPoint checkpoint : checkpoints) {
            float dst = pathPoint.func_75829_a((PathPoint)checkpoint);
            checkpoint.func_224761_a(dst, pathPoint);
            minDst = Math.min(dst, minDst);
        }
        return minDst;
    }

    protected Path createPath(PathPoint start, BlockPos target, boolean isTargetReached) {
        ArrayList points = Lists.newArrayList();
        PathPoint currentPathPoint = start;
        points.add(0, start);
        while (currentPathPoint.field_75841_h != null) {
            currentPathPoint = currentPathPoint.field_75841_h;
            points.add(0, currentPathPoint);
        }
        return new Path((List)points, target, isTargetReached);
    }

    public static interface Heuristic {
        public float compute(PathPoint var1, PathPoint var2, boolean var3);
    }
}

