/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.common.entity.movement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import tcb.spiderstpo.common.entity.movement.CustomPathFinder;
import tcb.spiderstpo.common.entity.movement.DirectionalPathPoint;

public class AdvancedPathFinder
extends CustomPathFinder {
    private static final Direction[] DOWN = new Direction[]{Direction.DOWN};

    public AdvancedPathFinder(NodeProcessor processor, int maxExpansions) {
        super(processor, maxExpansions);
    }

    @Override
    protected Path createPath(PathPoint _targetPoint, BlockPos target, boolean isTargetReached) {
        ArrayList<PathPoint> points = new ArrayList<PathPoint>();
        this.backtrackPath(points, _targetPoint);
        Node end = this.retraceSidedPath(points, true);
        if (end == null) {
            return new Path(Collections.emptyList(), target, isTargetReached);
        }
        points.clear();
        this.backtrackPath(points, end);
        return new Path(points, target, isTargetReached);
    }

    private void backtrackPath(List<PathPoint> points, PathPoint start) {
        PathPoint currentPathPoint = start;
        points.add(start);
        while (currentPathPoint.field_75841_h != null) {
            currentPathPoint = currentPathPoint.field_75841_h;
            points.add(currentPathPoint);
        }
    }

    private void backtrackPath(List<PathPoint> points, Node start) {
        Node currentNode = start;
        points.add(start.pathPoint);
        while (currentNode.previous != null) {
            currentNode = currentNode.previous;
            points.add(currentNode.pathPoint);
        }
    }

    private static Direction[] getPathableSidesWithFallback(DirectionalPathPoint point) {
        if (point.getPathableSides().length == 0) {
            return DOWN;
        }
        return point.getPathableSides();
    }

    private static boolean isOmnidirectionalPoint(DirectionalPathPoint point) {
        return point.field_186287_m == PathNodeType.WATER || point.field_186287_m == PathNodeType.LAVA;
    }

    private Node retraceSidedPath(List<PathPoint> points, boolean isReversed) {
        if (points.isEmpty()) {
            return null;
        }
        LinkedList<Node> queue = new LinkedList<Node>();
        DirectionalPathPoint targetPoint = this.ensureDirectional(points.get(0));
        for (Direction direction : AdvancedPathFinder.getPathableSidesWithFallback(targetPoint)) {
            queue.add(new Node(null, targetPoint.assignPathSide(direction)));
        }
        Node end = null;
        int maxExpansions = 200;
        HashSet<Node> checkedSet = new HashSet<Node>();
        int expansions = 0;
        while (!queue.isEmpty() && expansions++ <= 200) {
            Node current = (Node)queue.removeFirst();
            if (current.depth == points.size() - 1) {
                end = current;
                break;
            }
            Direction currentSide = current.side;
            DirectionalPathPoint next = this.ensureDirectional(points.get(current.depth + 1));
            for (Direction nextSide : AdvancedPathFinder.getPathableSidesWithFallback(next)) {
                Node nextNode = null;
                if (isReversed && current.pathPoint.isDrop() || !isReversed && next.isDrop()) {
                    nextNode = new Node(current, next.assignPathSide(nextSide));
                } else {
                    int adz;
                    int ady;
                    int dx = (int)Math.signum(next.field_75839_a - ((Node)current).pathPoint.field_75839_a);
                    int dy = (int)Math.signum(next.field_75837_b - ((Node)current).pathPoint.field_75837_b);
                    int dz = (int)Math.signum(next.field_75838_c - ((Node)current).pathPoint.field_75838_c);
                    int adx = Math.abs(dx);
                    int d = adx + (ady = Math.abs(dy)) + (adz = Math.abs(dz));
                    if (d == 1) {
                        if (nextSide == currentSide) {
                            nextNode = new Node(current, next.assignPathSide(nextSide));
                        } else if (nextSide.func_176740_k() != currentSide.func_176740_k()) {
                            Node intermediary = Math.abs(currentSide.func_82601_c()) == adx && Math.abs(currentSide.func_96559_d()) == ady && Math.abs(currentSide.func_82599_e()) == adz ? new Node(current, current.pathPoint.assignPathSide(nextSide)) : new Node(current, next.assignPathSide(currentSide));
                            nextNode = new Node(intermediary, intermediary.depth, next.assignPathSide(nextSide));
                        }
                    } else if (d == 2) {
                        int currentSidePlaneMatch = (currentSide.func_82601_c() == -dx ? 1 : 0) + (currentSide.func_96559_d() == -dy ? 1 : 0) + (currentSide.func_82599_e() == -dz ? 1 : 0);
                        if (currentSide == nextSide && currentSidePlaneMatch == 0) {
                            nextNode = new Node(current, next.assignPathSide(nextSide));
                        } else {
                            Node intermediary = null;
                            if (currentSidePlaneMatch == 2) {
                                for (Direction intermediarySide : AdvancedPathFinder.getPathableSidesWithFallback(current.pathPoint)) {
                                    if (intermediarySide == currentSide || (intermediarySide.func_82601_c() == dx ? 1 : 0) + (intermediarySide.func_96559_d() == dy ? 1 : 0) + (intermediarySide.func_82599_e() == dz ? 1 : 0) != 2) continue;
                                    intermediary = new Node(current, current.pathPoint.assignPathSide(intermediarySide));
                                    break;
                                }
                            } else {
                                for (Direction intermediarySide : AdvancedPathFinder.getPathableSidesWithFallback(next)) {
                                    if (intermediarySide == nextSide || (intermediarySide.func_82601_c() == -dx ? 1 : 0) + (intermediarySide.func_96559_d() == -dy ? 1 : 0) + (intermediarySide.func_82599_e() == -dz ? 1 : 0) != 2) continue;
                                    intermediary = new Node(current, next.assignPathSide(intermediarySide));
                                    break;
                                }
                            }
                            nextNode = intermediary != null ? new Node(intermediary, intermediary.depth, next.assignPathSide(nextSide)) : new Node(current, next.assignPathSide(nextSide));
                        }
                    }
                }
                if (nextNode == null || !checkedSet.add(nextNode)) continue;
                queue.addLast(nextNode);
            }
        }
        return end;
    }

    private DirectionalPathPoint ensureDirectional(PathPoint point) {
        if (point instanceof DirectionalPathPoint) {
            return (DirectionalPathPoint)point;
        }
        return new DirectionalPathPoint(point);
    }

    private static class Node {
        private final Node previous;
        private final DirectionalPathPoint pathPoint;
        private final Direction side;
        private final int depth;

        private Node(@Nullable Node previous, DirectionalPathPoint pathPoint) {
            this.previous = previous;
            this.depth = previous != null ? previous.depth + 1 : 0;
            this.pathPoint = pathPoint;
            this.side = pathPoint.getPathSide();
        }

        private Node(Node previous, int depth, DirectionalPathPoint pathPoint) {
            this.previous = previous;
            this.depth = depth;
            this.pathPoint = pathPoint;
            this.side = pathPoint.getPathSide();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.pathPoint == null ? 0 : this.pathPoint.hashCode());
            result = 31 * result + (this.side == null ? 0 : this.side.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            if (this.pathPoint == null ? other.pathPoint != null : !this.pathPoint.equals((Object)other.pathPoint)) {
                return false;
            }
            return this.side == other.side;
        }
    }
}

