/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.noise.domain;

import com.terraforged.cereal.spec.Context;
import com.terraforged.cereal.spec.DataSpec;
import com.terraforged.cereal.value.DataObject;
import com.terraforged.noise.domain.Domain;

public class CacheWarp
implements Domain {
    private final Domain domain;
    private boolean cached = false;
    private float cachedX;
    private float cachedY;
    private float x;
    private float y;

    public CacheWarp(Domain domain) {
        this.domain = domain;
    }

    @Override
    public String getSpecName() {
        return "CacheWarp";
    }

    @Override
    public float getOffsetX(float x, float y) {
        if (this.cached && x == this.x && y == this.y) {
            return this.cachedX;
        }
        this.x = x;
        this.y = y;
        this.cachedX = this.domain.getOffsetX(x, y);
        return this.cachedX;
    }

    @Override
    public float getOffsetY(float x, float y) {
        if (this.cached && x == this.x && y == this.y) {
            return this.cachedY;
        }
        this.x = x;
        this.y = y;
        this.cachedY = this.domain.getOffsetY(x, y);
        return this.cachedY;
    }

    private static CacheWarp create(DataObject data, DataSpec<?> spec, Context context) {
        return new CacheWarp(spec.get("domain", data, Domain.class, context));
    }

    public static DataSpec<? extends Domain> spec() {
        return DataSpec.builder("CacheWarp", CacheWarp.class, CacheWarp::create).addObj("domain", Domain.class, w -> w.domain).build();
    }
}

