/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.server.command.search;

import com.terraforged.engine.cell.Cell;
import com.terraforged.engine.concurrent.Resource;
import com.terraforged.engine.concurrent.pool.ObjectPool;
import com.terraforged.engine.util.pos.PosUtil;
import com.terraforged.engine.world.WorldGenerator;
import com.terraforged.engine.world.terrain.Terrain;
import com.terraforged.mod.server.command.search.ChunkGeneratorSearch;
import com.terraforged.mod.server.command.search.condition.SearchCondition;
import com.terraforged.mod.server.command.search.condition.TerrainConditions;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.ChunkGenerator;

public class TerrainSearchTask
extends ChunkGeneratorSearch {
    private static final ObjectPool<LongSet> CACHE_POOL = new ObjectPool<LongSet>(8, () -> new LongOpenHashSet(1024));
    private final SearchCondition condition;
    private final WorldGenerator worldGenerator;
    private final Cell cell = new Cell();
    private final Resource<LongSet> cache;
    private long result = Long.MAX_VALUE;

    public TerrainSearchTask(BlockPos center, Terrain type, ChunkGenerator chunkGenerator, WorldGenerator worldGenerator) {
        super(center, 256, chunkGenerator);
        this.worldGenerator = worldGenerator;
        this.condition = TerrainConditions.get(type, worldGenerator.getHeightmap());
        this.cache = CACHE_POOL.get();
        worldGenerator.getHeightmap().getRegionModule().apply(this.cell, center.func_177958_n(), center.func_177952_p());
        this.cache.get().add(this.cell.terrainRegionCenter);
    }

    @Override
    public int getSpacing() {
        return 20;
    }

    @Override
    public boolean test(BlockPos pos) {
        long result;
        this.worldGenerator.getHeightmap().getRegionModule().apply(this.cell, pos.func_177958_n(), pos.func_177952_p());
        if (this.cache.get().add(this.cell.terrainRegionCenter) && (result = this.condition.test(this.cell, pos.func_177958_n(), pos.func_177952_p())) != Long.MAX_VALUE) {
            this.result = result;
            return true;
        }
        return false;
    }

    @Override
    public BlockPos success(BlockPos.Mutable pos) {
        int x = PosUtil.unpackLeft(this.result);
        int z = PosUtil.unpackRight(this.result);
        return super.success(pos.func_181079_c(x, pos.func_177956_o(), z));
    }

    @Override
    public void close() {
        this.cache.get().clear();
        this.cache.close();
    }
}

