/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.feature;

import com.terraforged.mod.biome.TFBiomeContainer;
import com.terraforged.mod.featuremanager.template.BlockUtils;
import com.terraforged.mod.util.Flags;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class FreezeLayer
extends Feature<NoFeatureConfig> {
    public static final FreezeLayer INSTANCE = new FreezeLayer();
    private static final int AIR_FLAG = 1;
    private static final int LOG_OR_LEAVES_FLAG = 2;
    private static final BiomeAccessor WORLD_BIOME_ACCESSOR = (world, container, pos) -> world.func_226691_t_(pos);
    private static final BiomeAccessor CONTAINER_BIOME_ACCESSOR = (world, container, pos) -> container.getBiome(pos.func_177958_n(), pos.func_177952_p());

    public FreezeLayer() {
        super(NoFeatureConfig.field_236558_a_);
        this.setRegistryName("terraforged", "freeze_top_layer");
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        BlockPos.Mutable pos1 = new BlockPos.Mutable();
        BlockPos.Mutable pos2 = new BlockPos.Mutable();
        IChunk main = world.func_217349_x(pos);
        int mainChunkX = main.func_76632_l().field_77276_a;
        int mainChunkZ = main.func_76632_l().field_77275_b;
        int minX = (mainChunkX << 4) - 8;
        int minZ = (mainChunkZ << 4) - 8;
        int maxX = minX + 32;
        int maxZ = minZ + 32;
        for (int dz = -1; dz <= 1; ++dz) {
            for (int dx = -1; dx <= 1; ++dx) {
                int cx = mainChunkX + dx;
                int cz = mainChunkZ + dz;
                this.visitChunk((IWorld)world, cx, cz, minX, minZ, maxX, maxZ, pos1, pos2, dx == 0 && dz == 0);
            }
        }
        return true;
    }

    private void visitChunk(IWorld world, int chunkX, int chunkZ, int areaMinX, int areaMinZ, int areaMaxX, int areaMaxZ, BlockPos.Mutable pos1, BlockPos.Mutable pos2, boolean main) {
        IChunk chunk = world.func_217353_a(chunkX, chunkZ, ChunkStatus.field_222608_d, false);
        if (chunk == null) {
            return;
        }
        if (!main && !chunk.func_201589_g().func_209003_a(ChunkStatus.field_222613_i)) {
            return;
        }
        int chunkBlockX = chunkX << 4;
        int chunkBlockZ = chunkZ << 4;
        int minX = Math.max(areaMinX, chunkBlockX);
        int minZ = Math.max(areaMinZ, chunkBlockZ);
        int maxX = Math.min(areaMaxX, chunkBlockX + 15);
        int maxZ = Math.min(areaMaxZ, chunkBlockZ + 15);
        TFBiomeContainer biomes = FreezeLayer.getBiomeContainer(chunk);
        BiomeAccessor biomeAccessor = FreezeLayer.getBiomeAccesor(biomes);
        Heightmap leavesHeightmap = chunk.func_217303_b(Heightmap.Type.MOTION_BLOCKING);
        Heightmap groundHeightmap = chunk.func_217303_b(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        for (int z = minZ; z <= maxZ; ++z) {
            int dz = z & 0xF;
            for (int x = minX; x <= maxX; ++x) {
                int dx = x & 0xF;
                int leavesY = leavesHeightmap.func_202273_a(dx, dz);
                int groundY = groundHeightmap.func_202273_a(dx, dz);
                pos1.func_181079_c(x, leavesY, z);
                pos2.func_189533_g((Vector3i)pos1).func_189534_c(Direction.DOWN, 1);
                Biome biome = biomeAccessor.getBiome(world, biomes, (BlockPos)pos1);
                if (leavesY > groundY) {
                    this.freezeLeaves(world, chunk, biome, pos1, pos2);
                }
                if (!main) continue;
                pos1.func_181079_c(x, groundY, z);
                pos2.func_189533_g((Vector3i)pos1).func_189534_c(Direction.DOWN, 1);
                this.freezeGround(world, chunk, biome, pos1, pos2);
            }
        }
    }

    private void freezeLeaves(IWorld world, IChunk chunk, Biome biome, BlockPos.Mutable pos, BlockPos.Mutable below) {
        if (biome.func_201850_b((IWorldReader)world, (BlockPos)pos)) {
            BlockState stateUnder = chunk.func_180495_p((BlockPos)below);
            if (stateUnder.func_177230_c() == Blocks.field_150350_a) {
                return;
            }
            this.setSnow(chunk, (BlockPos)pos, (BlockPos)below, stateUnder);
        }
    }

    private void freezeGround(IWorld world, IChunk chunk, Biome biome, BlockPos.Mutable snowPos, BlockPos.Mutable underPos) {
        if (biome.func_201854_a((IWorldReader)world, (BlockPos)underPos, false)) {
            chunk.func_177436_a((BlockPos)underPos, Blocks.field_150432_aD.func_176223_P(), false);
        }
        if (biome.func_201850_b((IWorldReader)world, (BlockPos)snowPos)) {
            BlockState stateUnder = chunk.func_180495_p((BlockPos)underPos);
            if (BlockUtils.isAir(stateUnder, (IBlockReader)chunk, (BlockPos)underPos)) {
                return;
            }
            if (BlockTags.field_200031_h.func_230235_a_((Object)stateUnder.func_177230_c())) {
                return;
            }
            int stateAbove = this.getAboveStateFlags(chunk, snowPos);
            if (Flags.has(stateAbove, 2)) {
                return;
            }
            if (this.setSnow(chunk, (BlockPos)snowPos, (BlockPos)underPos, stateUnder) && !Flags.has(stateAbove, 1)) {
                chunk.func_177436_a((BlockPos)snowPos.func_189534_c(Direction.UP, 1), Blocks.field_150350_a.func_176223_P(), false);
            }
        }
    }

    private int getAboveStateFlags(IChunk chunk, BlockPos.Mutable pos) {
        pos.func_189534_c(Direction.UP, 1);
        BlockState state = chunk.func_180495_p((BlockPos)pos);
        boolean air = BlockUtils.isAir(state, (IBlockReader)chunk, (BlockPos)pos);
        boolean tree = !air && BlockUtils.isLeavesOrLogs(state);
        pos.func_189534_c(Direction.DOWN, 1);
        return Flags.get(air, tree);
    }

    private boolean setSnow(IChunk chunk, BlockPos pos1, BlockPos pos2, BlockState below) {
        if (BlockUtils.isSolid((IBlockReader)chunk, pos1)) {
            return false;
        }
        chunk.func_177436_a(pos1, Blocks.field_150433_aE.func_176223_P(), false);
        if (below.func_235901_b_((Property)SnowyDirtBlock.field_196382_a)) {
            chunk.func_177436_a(pos2, (BlockState)below.func_206870_a((Property)SnowyDirtBlock.field_196382_a, (Comparable)Boolean.valueOf(true)), false);
        }
        return true;
    }

    @Nullable
    private static TFBiomeContainer getBiomeContainer(IChunk chunk) {
        BiomeContainer biomes = chunk.func_225549_i_();
        if (biomes instanceof TFBiomeContainer) {
            return (TFBiomeContainer)biomes;
        }
        return null;
    }

    private static BiomeAccessor getBiomeAccesor(@Nullable TFBiomeContainer biomes) {
        return biomes == null ? WORLD_BIOME_ACCESSOR : CONTAINER_BIOME_ACCESSOR;
    }

    private static interface BiomeAccessor {
        public Biome getBiome(IWorld var1, TFBiomeContainer var2, BlockPos var3);
    }
}

