/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.util;

import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.util.math.BlockPos;

public class ChunkBitSet
implements Spliterator<BlockPos.Mutable> {
    private int index = -1;
    private int count = 0;
    private long l0;
    private long l1;
    private long l2;
    private long l3;
    private int offsetX;
    private int offsetY;
    private int offsetZ;
    private final BlockPos.Mutable pos = new BlockPos.Mutable();

    public void set(int x, int z) {
        this.set(z + (x << 4));
    }

    public void set(int index) {
        int i = index >> 6;
        if (i == 0) {
            this.l0 |= 1L << index;
            ++this.count;
        } else if (i == 1) {
            this.l1 |= 1L << index;
            ++this.count;
        } else if (i == 2) {
            this.l2 |= 1L << index;
            ++this.count;
        } else if (i == 3) {
            this.l3 |= 1L << index;
            ++this.count;
        }
    }

    public boolean get(int x, int z) {
        return this.get(z + (x << 4));
    }

    public boolean get(int index) {
        int i = index >> 6;
        return (this.getSection(i) & 1L << index) != 0L;
    }

    public int next(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + index);
        }
        int sectionIndex = index >> 6;
        if (sectionIndex > 3) {
            return -1;
        }
        long section = this.getSection(sectionIndex) & -1L << index;
        while (section == 0L) {
            if (++sectionIndex == 4) {
                return -1;
            }
            section = this.getSection(sectionIndex);
        }
        return sectionIndex * 64 + Long.numberOfTrailingZeros(section);
    }

    public Stream<BlockPos.Mutable> stream() {
        return this.stream(0, 0, 0);
    }

    public Stream<BlockPos.Mutable> stream(int x, int y, int z) {
        this.index = -1;
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        return StreamSupport.stream(this, false);
    }

    @Override
    public boolean tryAdvance(Consumer<? super BlockPos.Mutable> action) {
        this.index = this.next(this.index + 1);
        if (this.index == -1) {
            return false;
        }
        int x = this.index >> 4;
        int z = this.index - (x << 4);
        action.accept((BlockPos.Mutable)this.pos.func_181079_c(this.offsetX + x, this.offsetY, this.offsetZ + z));
        return true;
    }

    @Override
    public Spliterator<BlockPos.Mutable> trySplit() {
        return this;
    }

    @Override
    public long estimateSize() {
        return this.count;
    }

    @Override
    public int characteristics() {
        return 17;
    }

    private long getSection(int i) {
        if (i == 0) {
            return this.l0;
        }
        if (i == 1) {
            return this.l1;
        }
        if (i == 2) {
            return this.l2;
        }
        if (i == 3) {
            return this.l3;
        }
        return 0L;
    }
}

