/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.column.post;

import com.terraforged.engine.cell.Cell;
import com.terraforged.engine.concurrent.task.LazySupplier;
import com.terraforged.engine.world.heightmap.Levels;
import com.terraforged.mod.api.chunk.column.ColumnDecorator;
import com.terraforged.mod.api.chunk.column.DecoratorContext;
import com.terraforged.mod.api.material.layer.LayerManager;
import com.terraforged.mod.api.material.layer.LayerMaterial;
import com.terraforged.mod.api.material.state.States;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SpreadableSnowyDirtBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.chunk.IChunk;

public class LayerDecorator
implements ColumnDecorator {
    private final LazySupplier<LayerManager> layerManager;

    public LayerDecorator(LazySupplier<LayerManager> layerManager) {
        this.layerManager = layerManager;
    }

    @Override
    public void decorate(IChunk chunk, DecoratorContext context, int x, int y, int z) {
        LayerMaterial material;
        context.pos.func_181079_c(x, y + 1, z);
        BlockState state = chunk.func_180495_p((BlockPos)context.pos);
        if (state.isAir((IBlockReader)chunk, (BlockPos)context.pos)) {
            context.pos.func_181079_c(x, y, z);
            state = chunk.func_180495_p((BlockPos)context.pos);
            if (state.isAir((IBlockReader)chunk, (BlockPos)context.pos)) {
                return;
            }
        }
        if ((material = ((LayerManager)this.layerManager.get()).getMaterial(state.func_177230_c())) == null) {
            return;
        }
        this.setLayer(chunk, (BlockPos)context.pos, material, context.cell, context.levels, 0.0f);
    }

    private void setLayer(IChunk chunk, BlockPos pos, LayerMaterial material, Cell cell, Levels levels, float min) {
        float height = cell.value * (float)levels.worldHeight;
        float depth = material.getDepth(height);
        if (depth > min) {
            int level = material.getLevel(depth);
            BlockState layer = material.getState(level);
            if (layer == LayerMaterial.NONE) {
                return;
            }
            chunk.func_177436_a(pos, layer, false);
            this.fixBaseBlock(chunk, pos, layer, level);
        }
    }

    private void fixBaseBlock(IChunk chunk, BlockPos pos, BlockState layerMaterial, int level) {
        BlockPos pos1;
        BlockState below;
        if (level > 1 && layerMaterial.func_203425_a(Blocks.field_150433_aE) && (below = chunk.func_180495_p(pos1 = pos.func_177977_b())).func_177230_c() instanceof SpreadableSnowyDirtBlock) {
            chunk.func_177436_a(pos1, (BlockState)States.DIRT_SNOW.get(), false);
        }
    }
}

