/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.spawn;

import com.terraforged.engine.util.pos.PosUtil;
import com.terraforged.engine.world.continent.SpawnType;
import com.terraforged.engine.world.heightmap.Heightmap;
import com.terraforged.mod.Log;
import com.terraforged.mod.biome.provider.TFBiomeProvider;
import com.terraforged.mod.biome.spawn.SpawnSearch;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.ServerWorldInfo;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpawnHandler {
    @SubscribeEvent
    public static void createSpawn(WorldEvent.CreateSpawnPosition event) {
        ServerWorld world;
        ChunkGenerator generator;
        if (event.getWorld() instanceof ServerWorld && (generator = (world = (ServerWorld)event.getWorld()).func_72863_F().func_201711_g()).func_202090_b() instanceof TFBiomeProvider) {
            Log.info("Searching for world spawn position", new Object[0]);
            TFBiomeProvider provider = (TFBiomeProvider)generator.func_202090_b();
            BlockPos center = SpawnHandler.getSearchCenter(provider);
            SpawnSearch search = new SpawnSearch(center, provider);
            BlockPos spawn = SpawnHandler.getSurface(generator, search.get());
            Log.info("Setting world spawn: {}", spawn);
            event.setCanceled(true);
            ServerWorldInfo info = (ServerWorldInfo)event.getSettings();
            info.func_76058_a(spawn.func_177958_n());
            info.func_76056_b(spawn.func_177956_o());
            info.func_76087_c(spawn.func_177952_p());
            if (info.func_230418_z_().func_236223_d_()) {
                Log.info("Generating bonus chest", new Object[0]);
                SpawnHandler.createBonusChest(world, spawn);
            }
        }
    }

    private static BlockPos getSearchCenter(TFBiomeProvider provider) {
        SpawnType spawnType = provider.getContext().terraSettings.world.properties.spawnType;
        if (spawnType == SpawnType.WORLD_ORIGIN) {
            return BlockPos.field_177992_a;
        }
        long center = ((Heightmap)provider.getContext().heightmap.get()).getContinent().getNearestCenter(0.0f, 0.0f);
        int x = PosUtil.unpackLeft(center);
        int z = PosUtil.unpackRight(center);
        return new BlockPos(x, 0, z);
    }

    private static BlockPos getSurface(ChunkGenerator generator, BlockPos pos) {
        int surface = generator.func_222529_a(pos.func_177958_n(), pos.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
        return new BlockPos(pos.func_177958_n(), surface, pos.func_177952_p());
    }

    private static void createBonusChest(ServerWorld world, BlockPos pos) {
        ConfiguredFeature chest = Feature.field_214487_aO.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
        chest.func_242765_a((ISeedReader)world, world.func_72863_F().func_201711_g(), world.field_73012_v, pos);
    }
}

