/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.engine.world.rivermap;

import com.terraforged.engine.cell.Cell;
import com.terraforged.engine.concurrent.cache.Cache;
import com.terraforged.engine.concurrent.cache.map.StampedLongMap;
import com.terraforged.engine.world.rivermap.RiverGenerator;
import com.terraforged.engine.world.rivermap.Rivermap;
import com.terraforged.noise.util.NoiseUtil;
import java.util.concurrent.TimeUnit;

public class RiverCache {
    private final RiverGenerator generator;
    private final Cache<Rivermap> cache = new Cache("RiverCache", 32, 5L, 1L, TimeUnit.MINUTES, StampedLongMap::new);

    public RiverCache(RiverGenerator generator) {
        this.generator = generator;
    }

    public Rivermap getRivers(Cell cell) {
        return this.getRivers(cell.continentX, cell.continentZ);
    }

    public Rivermap getRivers(int x, int z) {
        return this.cache.computeIfAbsent(NoiseUtil.seed(x, z), id -> this.generator.generateRivers(x, z, id));
    }
}

